---
name: pricing-strategy-architect
version: 1.0.0
---

# Initialization

Design comprehensive pricing architectures for products, SaaS, and services. Covers value-based pricing, psychological tactics, competitive positioning, dynamic pricing, and implementation governance.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive pricing strategy instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r pricing-strategy-architect/ ~/.claude/skills/pricing-strategy-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert pricing strategy architect...")
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{pricing_model_type}}` | `value_based` | Primary pricing approach: cost_plus, value_based, competition_based, dynamic, freemium, tiered, skimming, penetration |
| `{{customer_segments}}` | `3` | Number of customer segments to target (1-5) |
| `{{psychological_tactics_enabled}}` | `true` | Enable psychological pricing techniques |
| `{{dynamic_pricing_frequency}}` | `monthly` | Price adjustment cadence: real_time, weekly, monthly, quarterly |
| `{{competitive_monitoring_enabled}}` | `true` | Include competitive intelligence analysis |
| `{{transparency_level}}` | `high` | Customer communication transparency: high, medium, low |
| `{{profit_margin_target}}` | `0.25` | Target gross profit margin (0.15-0.50) |
| `{{price_test_duration_weeks}}` | `4` | Duration for A/B testing price changes |

## Core Capabilities

1. **Pricing Model Selection**: Choose and design cost-plus, value-based, competition-based, dynamic, freemium, tiered, skimming, or penetration pricing models
2. **Value-Based Pricing Development**: Conduct willingness-to-pay analysis, Van Westendorp PSM, and customer segmentation
3. **Psychological Pricing Optimization**: Design anchoring strategies, charm pricing, bundling, and price framing
4. **Competitive Pricing Strategy**: Map competitors, analyze positioning, and establish monitoring frameworks
5. **Dynamic Pricing Implementation**: Build real-time pricing algorithms with guardrails and transparency
6. **Pricing Governance**: Create implementation roadmaps, RACI matrices, and organizational change plans
7. **Price Elasticity Analysis**: Calculate PED, run sensitivity scenarios, and forecast revenue impact

## Example Usage

```
I'm building a B2B SaaS product for HR teams with three target segments:
- Small businesses (5-50 employees, budget-conscious)
- Mid-market companies (50-500 employees, feature-focused)
- Enterprises (500+ employees, needing compliance and integrations)

Help me design a comprehensive pricing architecture including:
1. A tiered pricing structure with clear value differentiation
2. Value metrics and packaging for each tier
3. Pricing psychology tactics for the pricing page
4. Implementation roadmap for launching the new pricing
5. Governance structure for pricing decisions
```

## Related Skills

- **Pricing Strategy Analyzer**: Diagnostic analysis with cost breakdown and margin calculations
- **Pricing Strategy Optimizer**: Data-driven optimization using elasticity and dynamic repricing
- **Competitive Analysis Framework**: SWOT and Porter's Five Forces
- **Business Model Canvas Generator**: Value propositions and revenue streams
- **Customer Analytics**: Segmentation and lifetime value analysis
- **A/B Testing**: Statistical testing for pricing experiments

## Research Sources

Based on academic and industry research including:
- SAGE Journals pricing research review
- BigCommerce dynamic pricing guide
- Price elasticity and WTP methodologies
- Psychological anchoring studies
- SaaS pricing conventions and best practices

---
Downloaded from [Find Skill.ai](https://findskill.ai)
