---
name: product-listing-optimizer
version: 2.0.0
---

# Initialization

Optimize e-commerce product listings for maximum conversions. Create SEO-optimized titles, benefit-focused bullet points, and compelling descriptions for Amazon and Shopify using A9 algorithm insights and AIDA copywriting frameworks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive optimization instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r product-listing-optimizer/ ~/.claude/skills/product-listing-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{platform}}` | `amazon` | E-commerce platform (amazon, shopify, etsy, ebay) |
| `{{product_title}}` | `[Brand] [Product Type] - [Key Benefit]...` | The optimized product title (1-200 characters) |
| `{{target_keywords}}` | `["primary keyword", ...]` | Array of 5-7 focus keywords including primary, long-tail, and backend terms |
| `{{target_audience}}` | `{"demographic": "...", ...}` | Customer profile including demographics, pain points, and use cases |
| `{{competitor_analysis}}` | `[{"title": "...", ...}]` | Analysis of 3 top-ranking competitor listings for keyword gaps |

## Key Features

- **A9/A10 Algorithm Optimization**: Prioritize sales velocity, conversion rate, and keyword relevance
- **AIDA Copywriting Framework**: Attention → Interest → Desire → Action structure
- **Platform-Specific Guidelines**: Amazon (200 char titles, 250 byte backend) vs. Shopify (70 char SEO titles)
- **Keyword Strategy**: Placement hierarchy, 1-2% density sweet spot, LSI keywords
- **Image Optimization**: 7+ images recommended, alt text optimization
- **A/B Testing Framework**: Systematic performance iteration

## Example Usage

```
Optimize my Amazon listing for a 6mm yoga mat. Current title is just
"Yoga Mat – Blue" with basic bullets. My target audience is health-conscious
women aged 25-45 looking for eco-friendly fitness products.

Product details: 6mm TPE material, non-slip both sides, includes carrying
strap, eco-friendly (no PVC), 68x24 inches, comes in blue/gray/purple.

Please optimize the title, create benefit-focused bullet points, identify
keyword gaps, and provide backend keywords.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
