---
name: prompt-debugging-coach
version: 1.0.0
---

# Initialization

**Prompt Debugging & Iteration Coach** is an AI skill that teaches you how to systematically diagnose why AI prompts fail and fix the root cause—not just tweak words randomly.

This skill covers:
- **Five Failure Categories**: Template Syndrome, Wrong Model Selection, Lazy Answers, Ambiguous Instructions, Token Dilution
- **5-Step Debugging Framework**: Reproduce, Isolate, Identify Root Cause, Apply Fix, Verify
- **Prompting Frameworks**: RISEN, CO-STAR, Chain-of-Thought, Few-Shot
- **Model Selection Guide**: When to use Claude vs GPT-4o vs Gemini
- **Constraint-Shift Testing**: Detecting lazy answers vs genuine limitations

## Structure

```
prompt-debugging-coach/
├── SKILL.md          # Main skill prompt (copy this to use)
└── INIT.md           # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r prompt-debugging-coach/ ~/.claude/skills/prompt-debugging-coach/

# Or add to your project's skills
cp -r prompt-debugging-coach/ .claude/skills/prompt-debugging-coach/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's chat or custom instructions

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content as system instructions
3. Name it "Prompt Debugging Coach"
4. Set description: "Diagnose why your AI prompts fail and fix the root cause"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{failing_prompt}}` | `[Paste your current prompt here]` | The prompt that's not working as expected |
| `{{expected_output}}` | `Specific, actionable, detailed response` | What you wanted the AI to produce |
| `{{actual_output}}` | `Generic, vague, or incorrect response` | What the AI actually produced |
| `{{model_used}}` | `claude-3.5-sonnet` | Which AI model you're using |
| `{{temperature}}` | `0` | Randomness setting (0=deterministic, 2=creative) |
| `{{context_level}}` | `balanced` | How much background context to include |

## Quick Start Example

After installing, start a conversation with:

```
My prompt is: "Write me a marketing email."

I keep getting generic, boring outputs that don't match my brand voice.
I've tried adding "make it creative" but it doesn't help.

Help me debug this prompt.
```

The coach will:
1. Diagnose this as "Template Syndrome"
2. Explain why generic prompts produce generic outputs
3. Apply the RISEN framework to add role, context, and constraints
4. Provide a revised prompt to test
5. Verify the fix with constraint-shift testing

## Key Concepts

### The Five Failure Categories

| Category | Symptom | Quick Fix |
|----------|---------|-----------|
| Template Syndrome | Generic, bland output | Add role + context + constraints |
| Wrong Model | Wrong task type (code bugs, flat writing) | Switch models based on strengths |
| Lazy Answer | Vague, hedging, "it depends" | Add constraints, use constraint-shift test |
| Ambiguity | Inconsistent outputs | Reduce entropy with specifics |
| Token Dilution | Ignored instructions | Shorten, restructure, repeat key points |

### Model Selection Cheat Sheet

| Task | Best Model | Why |
|------|------------|-----|
| Code | Claude 3.5 Sonnet | 93.7% accuracy |
| Analysis | Claude 3.5 Sonnet | Low hallucination |
| Creative | GPT-4o | Human-like flair |
| Research | Gemini 1.5 Pro | Real-time data |
| Long docs | Gemini 1.5 Pro | 2M context window |

### RISEN Framework Template

```
**Role:** You are a [expertise] specialist.
**Instructions:** [What to do]
**Steps:**
1. [Step 1]
2. [Step 2]
3. [Step 3]
**End Goal:** [Success criteria]
**Narrowing:** Do NOT [exclusions]. Keep under [limits].
```

## Related Skills

- **10x Your Prompts**: Iteration mastery with A/B testing
- **Prompt Engineering Patterns**: Advanced production techniques
- **System Prompt Architect**: Design system prompts for AI assistants
- **Systematic Debugging**: Apply debugging methodology to code

---
Downloaded from [Find Skill.ai](https://findskill.ai)
