---
name: quarterly-tax-estimator
version: 1.0.0
---

# Initialization

Calculate estimated quarterly tax payments for self-employed individuals and freelancers to avoid IRS underpayment penalties with accurate projections.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with tax bracket tables, calculation workflows, and output templates

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r quarterly-tax-estimator/ ~/.claude/skills/quarterly-tax-estimator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{tax_year}}` | `2025` | The fiscal year being calculated |
| `{{filing_status}}` | `single` | Tax filing status |
| `{{state}}` | `none` | State of residence for state taxes |
| `{{business_type}}` | `freelance` | Type of self-employment |
| `{{include_state_taxes}}` | `yes` | Whether to calculate state estimated taxes |

## Key Features

- **Federal Tax Brackets**: 2025 brackets for all filing statuses
- **Self-Employment Tax**: 15.3% calculation with Social Security cap
- **Safe Harbor Rules**: 100%/110% prior year method
- **Quarterly Schedule**: All four payment deadlines with amounts
- **State Taxes**: Support for all 50 states
- **Penalty Avoidance**: Clear guidance on meeting safe harbor requirements

## Example Usage

> Calculate my quarterly estimated taxes. I'm single, self-employed as a freelance consultant. My projected annual income is $95,000. I expect $8,000 in business deductions. Last year I paid $14,500 in total federal tax. I live in California. What should my Q4 payment be?

---
Downloaded from [Find Skill.ai](https://findskill.ai)
