---
name: quiet-quitting-escape-plan
version: 1.0.0
---

# Initialization

Transform career disengagement into strategic action with comprehensive guidance for burnout assessment, boundary-setting, job search planning, and professional transitions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructions for burnout assessment, career transition planning, boundary-setting, job search strategy, and post-transition recovery

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r quiet-quitting-escape-plan/ ~/.claude/skills/quiet-quitting-escape-plan/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{burnout_severity_threshold}}` | `7` | Engagement score (0-10) triggering urgent exit recommendation vs. recovery attempt |
| `{{financial_runway_months}}` | `6` | Recommended months of expenses to save before leaving job |
| `{{skill_gap_severity}}` | `Moderate` | Classification level (None/Mild/Moderate/Severe) determining skill development time |
| `{{networking_effort_allocation}}` | `60%` | Percentage of job search time devoted to networking vs. applications |
| `{{job_search_timeline_months}}` | `6` | Target timeline for completing job transition |
| `{{boundary_implementation_weeks}}` | `8` | Timeframe for gradually implementing boundaries if recovering engagement |

## Core Capabilities

1. **Burnout Assessment** - Identify signs of quiet quitting and burnout using Maslach framework
2. **Career Transition Planning** - Develop 6-12 month strategic exit roadmaps
3. **Boundary-Setting** - Establish healthy work boundaries to recover engagement
4. **Job Search Strategy** - Create customized job hunting approaches with networking focus
5. **Personal Branding** - Craft compelling narratives for resumes, interviews, and LinkedIn
6. **Post-Transition Recovery** - Navigate onboarding and prevent burnout recurrence

## Example Usage

```
I've been in my product management role for 7 years. I love the work but
I'm exhausted. I'm working 55+ hours/week, feeling disconnected from my
team, my manager doesn't recognize my contributions, and there's no clear
career path. I haven't attended a conference or mentored anyone in 2 years.
Should I quit or can I recover this? I have $50K saved and make $120K/year.
```

## Research Sources

- Emerald systematic literature review on quiet quitting (ABC framework)
- McKinsey analysis on hidden costs of quiet quitting
- NIH studies on burnout in high-stress industries
- Frontiers Psychology on career transition psychology
- FlexJobs strategic job search methodology
- Career Directors expert strategies for 2025 job seekers

---
Downloaded from [Find Skill.ai](https://findskill.ai)
