---
name: recommendation-letter-writer
version: 1.0.0
description: Write compelling recommendation letters for any context
author: FindSkill.ai
license: MIT
---

# Recommendation Letter Writer — Initialization

## Overview

This is a prompt-only skill for writing specific, genuine recommendation letters. It uses a proven 5-part structure and adapts for jobs, college, grad school, scholarships, and character references.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with 5-part framework and type-specific templates
- `INIT.md` — This initialization guide

## Directory Structure

```
recommendation-letter-writer/
├── SKILL.md    # Main skill with templates and power phrases
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude who you're recommending and what for

### ChatGPT / Gemini / Copilot
Same process — paste and describe the candidate and opportunity.

## Core Capabilities

1. **5-Part Structure** — Opening, two strengths with stories, character, strong close
2. **Type-Specific Templates** — Job, college, grad school, scholarship, character
3. **Power Phrases Library** — Strong language for skills, character, comparisons, closings
4. **Doubt Raiser Detection** — Flags words that accidentally undermine the candidate
5. **Information Gathering** — Asks the right questions to write a specific letter
6. **Formatting Guidance** — Font, length, letterhead, delivery recommendations
7. **Ethics Check** — Helps users decide if they should write the letter
8. **Customization Markers** — Highlights where to add personal touches

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `letter_type` | `job` | Type of recommendation (job, college, grad school, scholarship, character) |
| `relationship` | `manager` | Your relationship to the candidate |
| `tone` | `enthusiastic and professional` | Letter tone |

## Usage Examples

### Example 1: Job Recommendation

**User:** "My former direct report is applying for a senior PM role at Google. She led our biggest product launch."

**AI Response:** Writes a one-page professional letter highlighting her product leadership, specific launch metrics, and team management. Includes comparison phrase and strong closing.

### Example 2: College Admissions

**User:** "I'm a high school teacher recommending a student for MIT. She's brilliant at math and started a tutoring club."

**AI Response:** Writes a warm 1.5-page letter focusing on intellectual curiosity, community contribution, and a specific story about her tutoring impact. Follows MIT admissions guidance.

### Example 3: Character Reference

**User:** "My neighbor needs a character reference for a custody case. He's a great dad."

**AI Response:** Writes a personal, sincere letter focusing on parenting observations, reliability, and community involvement. Appropriate tone for legal context.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Don't know what to highlight | Tell the AI about the candidate's proudest moment |
| Letter sounds generic | Add more specific stories and metrics |
| Too short | Ask the AI to expand with additional examples |
| Too long | Ask for "one page maximum" version |
| Not sure about tone | Tell the AI who's reading it (HR, admissions, judge) |

## Best Practices

1. **Always ask the candidate** what they'd like you to highlight
2. **Get the details** — job description, school name, scholarship criteria
3. **Use specific numbers** — "increased by 40%" beats "improved significantly"
4. **Don't decline and write a bad letter** — if you can't recommend, say no
5. **Proofread the candidate's name** — misspelling their name is devastating
6. **Send on time** — late letters can disqualify candidates

---
Downloaded from [Find Skill.ai](https://findskill.ai)
