---
title: "Recommendation Letter Writer"
description: "Write compelling recommendation letters for jobs, college, grad school, scholarships, or character references. Uses a proven 5-part structure with specific examples."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "letter_type"
    default: "job"
    description: "Type of recommendation"
  - name: "relationship"
    default: "manager"
    description: "Your relationship to the candidate"
  - name: "tone"
    default: "enthusiastic and professional"
    description: "Letter tone"
---

# Recommendation Letter Writer

A skill that helps you write specific, compelling recommendation letters for any context — job applications, college admissions, graduate school, scholarships, awards, and character references.

## When to Use This Skill

- A colleague, employee, or student asks you for a recommendation letter
- You need to write a reference for someone applying to a program
- A friend or family member needs a character reference
- You want to help someone but don't know where to start

## Core Framework: 5-Part Structure

### Part 1 — Opening & Credibility
Introduce yourself, establish your relationship, state your recommendation upfront.

### Part 2 — Key Strength #1 with Story
Highlight the most relevant strength with a specific example and outcome.

### Part 3 — Key Strength #2 with Story
Show range with a second strength and different example.

### Part 4 — Character & Fit
Speak to who the person IS and connect to the opportunity.

### Part 5 — Strong Close
Summarize recommendation, offer contact info, use power phrases.

## Type-Specific Guidance

### Job Applications
- Professional skills, leadership, measurable results
- Include metrics (revenue, team size, outcomes)
- One page, company letterhead

### College Admissions
- Intellectual curiosity, character, growth
- Stories that reveal the whole person
- Community contribution
- Can be 1-1.5 pages

### Graduate School
- Research ability, independent thinking, academic potential
- Compare to peers: "Top 5% of students I've taught"
- Reference specific projects or publications

### Scholarships
- Merit, community impact, leadership
- Connect to scholarship's mission
- Service examples

### Character References
- Personal qualities: integrity, reliability, compassion
- Personal stories, more informal tone
- For housing, legal, volunteer contexts

## Power Phrases

**Skills:** "consistently exceeded expectations," "demonstrated exceptional aptitude"
**Character:** "possesses rare combination of," "natural ability to"
**Comparisons:** "among the top X% I have worked with," "the strongest I have managed in X years"
**Closings:** "highest and most enthusiastic recommendation," "without any reservation"

## Things to Avoid

- Doubt raisers: "seems to be," "appears to," faint praise
- Going over one page (unless academic)
- Being generic without specific examples
- Including protected characteristics
- Writing a letter you can't honestly stand behind

---
Downloaded from [Find Skill.ai](https://findskill.ai)
