---
name: relocation-regret-minimizer
version: 1.0.0
---

# Initialization

Relocation Regret Minimizer is an AI-guided decision framework that helps people rigorously test a potential move before committing. It provides structured approaches for clarifying motivations, researching destinations, designing trial visits, stress-testing finances, and planning for community building and identity preservation.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive relocation decision guidance

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly into your AI assistant)

## Dependencies

None required. The skill works standalone with any major AI assistant.

## Post-Init Steps

### Claude Code
```bash
cp -r relocation-regret-minimizer/ ~/.claude/skills/relocation-regret-minimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Start a new conversation with: "Help me evaluate whether I should relocate"

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

Works best with models that support:
- Long context windows (prompt is ~700 lines)
- Structured reasoning and multi-step workflows
- Financial calculations and scenario modeling

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{time_horizon_months}}` | `24` | Planning horizon for evaluating move outcomes |
| `{{risk_tolerance_level}}` | `medium` | Financial/lifestyle risk appetite (low, medium, high) |
| `{{trial_visit_length_weeks}}` | `4` | Preferred trial stay duration |
| `{{financial_buffer_months}}` | `6` | Target emergency runway in new location |
| `{{community_priority_weight}}` | `0.3` | Importance of social factors (0-1 scale) |
| `{{family_complexity_level}}` | `single` | Household type affecting planning depth |

## Core Capabilities

1. **"Should I Move?" Assessment** - Clarify push/pull factors and evaluate non-move alternatives
2. **Destination Research & Comparison** - Weighted criteria scoring and gap analysis
3. **Trial Visit Design** - "Live like a local" schedules with hypothesis testing
4. **Financial Stress-Testing** - Three-scenario projections and runway calculations
5. **Identity & Community Mapping** - Anchor preservation and 90-day community plans
6. **Risk & Contingency Planning** - Exit strategies and reversibility preservation
7. **Personalized Checklist & Timeline** - Phase-by-phase moving plan

## Example Usage

```
I'm a 35-year-old marketing manager in Chicago considering relocating to Austin
or Denver for better lifestyle and career opportunities. Help me use the
Relocation Regret Minimizer framework to:

1. Clarify my push/pull factors and whether moving is the right solution
2. Build a weighted comparison of Austin vs Denver vs staying in Chicago
3. Design a 3-week trial visit plan for my top choice
4. Run a financial stress-test including moving costs and a job loss scenario

I value outdoor activities and social life highly, care moderately about cost,
and want to minimize long-term regret.
```

## Research Sources

This skill synthesizes insights from:
- 2025 Moving Trends research (70% regret statistics)
- Migration decision-making psychology studies
- Expat community experiences and trial-run discussions
- Financial planning best practices for relocations
- Community building and loneliness prevention research

## Related Skills

- Budget Planner - Financial planning for moves
- Rent vs Buy Decision Engine - Housing analysis
- Major Purchase Advisor - Large life decision framework
- Career Pivot Risk Calculator - Career change assessment
- Stress Management - Managing transition anxiety

---
Downloaded from [Find Skill.ai](https://findskill.ai)
