---
name: remote-work-location-strategy
version: 1.0.0
---

# Initialization

Remote Work Location Strategy helps remote workers and digital nomads optimize where to live by evaluating cost of living, timezone compatibility, visa eligibility, tax implications, and infrastructure quality. This skill provides systematic decision-making frameworks for international relocation while ensuring legal compliance and financial efficiency.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for location strategy consulting

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r remote-work-location-strategy/ ~/.claude/skills/remote-work-location-strategy/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's custom instructions or system prompt

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

This skill enables AI assistants to help users with:

1. **Cost of Living Analysis** - Compare expenses across destinations, calculate geographic arbitrage opportunities
2. **Timezone Mapping** - Assess compatibility with employers/clients, design optimized work schedules
3. **Visa Research** - Match situations to digital nomad visa programs, outline requirements and timelines
4. **Tax Residency Planning** - Navigate 183-day rules, identify treaty benefits, prevent double taxation
5. **Infrastructure Assessment** - Evaluate internet reliability, coworking options, backup plans
6. **Multi-Criteria Decisions** - Systematically compare and rank candidate destinations
7. **Risk Mitigation** - Plan for visa denial, currency changes, and emergency relocation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{min_monthly_budget_usd}}` | `2500` | Minimum affordable monthly spend |
| `{{timezone_overlap_hours}}` | `4` | Minimum synchronous work hours needed |
| `{{tax_residency_threshold_days}}` | `183` | Days triggering tax residency |
| `{{visa_processing_buffer_weeks}}` | `4` | Lead time for visa applications |
| `{{currency_stability_tolerance}}` | `0.9` | Risk tolerance for currency fluctuations |
| `{{internet_speed_minimum_mbps}}` | `25` | Minimum download speed required |

## Example Usage

```
I'm a US-based software developer earning $5,000/month from a US company.
I'm considering moving to Lisbon, Portugal. I want to work with a team in
San Francisco (9-hour timezone difference) and plan to stay for 18 months.

Help me evaluate:
1. Is Portugal's D8 digital nomad visa viable for me?
2. What's my estimated tax liability with FEIE and the US-Portugal tax treaty?
3. What's the monthly cost difference vs. San Francisco?
4. How do I structure my stay to avoid Portuguese tax residency?
5. What timezone challenges should I anticipate?
```

## Research Sources

This skill was developed using research from:
- Lincoln Global Partners (European Digital Nomad Visa Guide 2025)
- Global Wealth Protection (Tax Residency Country Rules)
- Nomad List (City Rankings and Community Data)
- Deel (Timezone Management Best Practices)
- Bright Tax (US Expat Tax Guidance)
- Global Citizen Solutions (Digital Nomad Visa Database)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
