---
name: rent-vs-buy-decision-engine
version: 1.0.0
---

# Initialization

Comprehensive financial and lifestyle analysis engine for the rent vs. buy housing decision. Incorporates hidden homeownership costs ($21,000+ annually), personal financial runway assessment, real estate market cycle analysis, opportunity cost comparison, and scenario stress testing.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete decision engine instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r rent-vs-buy-decision-engine/ ~/.claude/skills/rent-vs-buy-decision-engine/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert Housing Financial Analyst...")
3. Paste into your AI assistant as system prompt or conversation starter

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{monthly_rent_payment}}` | `1800` | Current or target monthly rent (housing only) |
| `{{home_purchase_price}}` | `350000` | Target home purchase price |
| `{{personal_runway_months}}` | `12` | Months of savings divided by monthly expenses |
| `{{market_cycle_phase}}` | `expansion` | recovery, expansion, hyper_supply, or recession |
| `{{holding_period_years}}` | `10` | Years you plan to stay in the home |
| `{{down_payment_percent}}` | `20` | Down payment as percentage of purchase price |
| `{{mortgage_interest_rate}}` | `6.5` | Current mortgage interest rate (annual %) |
| `{{state_code}}` | `US` | Two-letter state code for regional cost lookup |

## Core Capabilities

1. **Personal Runway Assessment** - Calculate months of financial safety buffer before and after purchase
2. **Hidden Cost Breakdown** - Property taxes, insurance, maintenance, utilities, HOA, PMI
3. **Market Cycle Analysis** - Identify current phase (recovery, expansion, hyper-supply, recession)
4. **Financial Comparison** - Multi-year buy vs. rent wealth projections with breakeven analysis
5. **Scenario Stress Testing** - Job loss, major repairs, market downturn, forced relocation
6. **Opportunity Cost Analysis** - Compare real estate vs. stock market investment returns

## Key Benchmarks

| Metric | Standard |
|--------|----------|
| Hidden Costs (National Avg) | $21,000+/year |
| Mortgage-to-Income | <28% gross |
| Debt-to-Income | <43% total |
| Down Payment (no PMI) | 20% |
| Maintenance Reserve | 1-4% of home value/year |
| Emergency Runway | 6-24 months |
| Breakeven Period | 5-7 years typical |

## Example Usage

```
I'm a software engineer in Seattle making $85,000/year. I have $45,000 saved
and currently rent for $1,200/month. I'm thinking about buying a home around
$450,000. My monthly expenses are about $2,500 including rent.

Before I commit, I need to understand:
1. What's my personal runway right now?
2. What are ALL the hidden costs I'm not thinking about?
3. Is Seattle in a buyer's or seller's market?
4. How long do I need to stay for buying to make financial sense?
5. What scenarios would make me regret this purchase?
```

## Research Sources

- Bankrate 2025 Hidden Homeownership Costs Study
- New York Times Rent vs. Buy Calculator
- Fidelity Rent vs. Buy Calculator
- Gatsby Investment Real Estate Market Cycles Guide
- Rocket Mortgage Buyer's vs. Seller's Market Guide
- Zillow Homeowner Costs Research
- LinkedIn Financial Runway Framework

---
Downloaded from [Find Skill.ai](https://findskill.ai)
