---
name: reorganization-announcement-drafter
version: 1.0.0
description: Craft professional restructuring and org change announcements with comprehensive communication packages
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps HR leaders, executives, and communications teams create complete communication packages for organizational restructuring. It covers everything from initial announcements to ongoing support materials.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
reorganization-announcement-drafter/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## What This Skill Covers

### Communication Types
- Company-wide announcement emails
- Slack/Teams short-form announcements
- All-hands meeting scripts
- Manager talking points
- FAQ documents
- Timeline communications

### Audience-Specific Content
- Executive/Board briefings
- Manager preparation materials
- All-employee announcements
- Directly affected individual communications
- External stakeholder messages

### Sensitive Situations
- Restructuring with layoffs
- Leadership departures
- Merger/acquisition announcements
- Department consolidations
- Role eliminations

## Usage Instructions

### For Claude Code

```bash
# Copy to your skills directory
cp -r reorganization-announcement-drafter/ ~/.claude/skills/reorganization-announcement-drafter/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

### Quick Start

Tell the AI:
- Type of change (restructuring, merger, layoffs, leadership change)
- Number of affected people and teams
- Timeline and effective date
- Any sensitive elements to address
- Outputs needed (announcement, talking points, FAQ, etc.)

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{change_type}}` | department restructuring | Type of org change |
| `{{affected_teams}}` | Engineering and Product | Impacted teams |
| `{{effective_date}}` | March 1, 2026 | When changes begin |
| `{{reason_for_change}}` | improve collaboration | Strategic rationale |

## Example Request

```
We're restructuring the Engineering and Product organizations to combine
them under a single CPO starting March 1st. About 120 people are affected.
Some reporting lines will change, but there are no layoffs.

I need:
1. Company-wide announcement email
2. Manager talking points for 1:1s
3. FAQ document for affected teams

The goal is to improve collaboration between these groups.
```

## Communication Timing Guide

| Audience | Timing | Channel |
|----------|--------|---------|
| Board/Executives | Before announcement | Private briefing |
| Senior Leadership | 24-48 hrs before | Leadership meeting |
| People Managers | Same day, before all-hands | Manager briefing |
| All Employees | All-hands + email | Multi-channel |
| Directly Affected | Same day, after general | 1:1 or small group |

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Post-Init Verification

After setup, test with: "Help me draft an announcement for a department restructuring where Marketing and Sales are being combined under one leader, effective next month."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
