---
name: reorganization-announcement-drafter
description: Craft professional restructuring and org change announcements with templates for all-hands, manager talking points, and FAQ documents. Use when communicating organizational changes, restructuring, leadership transitions, or workforce reductions.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: advanced
variables:
  - name: "change_type"
    default: "department restructuring"
    description: "Type of organizational change"
  - name: "affected_teams"
    default: "Engineering and Product teams"
    description: "Teams or employees impacted"
  - name: "effective_date"
    default: "March 1, 2026"
    description: "When changes take effect"
---

# Reorganization Announcement Drafter

Generate comprehensive communication packages for organizational restructuring and change announcements.

## Quick Start

Tell me about your organizational change:
- What type of change? (restructuring, merger, leadership change, layoffs)
- How many people are affected?
- What's the timeline?
- Are there any sensitive elements (layoffs, departures)?

I'll generate the appropriate communications tailored to your situation.

## What This Skill Creates

### Core Communications
- Company-wide announcement emails
- Slack/Teams short-form announcements
- All-hands meeting scripts
- Board/stakeholder briefings

### Manager Support
- Talking points with do's and don'ts
- Anticipated Q&A with approved responses
- Escalation paths
- 1:1 conversation guides

### Employee Resources
- FAQ documents (regularly updated)
- Anonymous question submission guidance
- Timeline and next steps
- Support resource listings

## Communication Timing Sequence

```
BEFORE          DAY 0              WEEK 1           MONTH 1+
Leadership  →   Announcement   →   Manager 1:1s  →  Progress Updates
Pre-brief       All-hands          FAQ Updates      Feedback Loops
                Manager Brief      Role Clarity     Success Stories
```

## Key Principles

### The CLARA Framework
- **C**lear: State what's changing explicitly
- **L**ogical: Explain why with business rationale
- **A**ction-oriented: Tell people what to do next
- **R**eassuring: Address fears directly
- **A**vailable: Provide channels for questions

### Tone by Situation
| Situation | Tone |
|-----------|------|
| General restructuring | Clear, confident, supportive |
| Layoffs involved | Empathetic, direct, honest |
| Leadership changes | Respectful, forward-looking |
| Merger/Acquisition | Optimistic, reassuring |

## Best Practices

- Brief managers BEFORE the all-hands announcement
- Be direct about what IS and ISN'T affected
- Provide multiple channels for questions (public and anonymous)
- Follow up within 24-48 hours on unanswered questions
- Update FAQ documents as new questions arise

---
Downloaded from [Find Skill.ai](https://findskill.ai)
