---
name: resource-reallocation-proposal
version: 1.0.0
description: Build data-driven proposals for shifting budget, headcount, or resources between projects
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps managers and leaders build persuasive proposals for reallocating budget, headcount, or other resources between projects using the SHIFT framework (Situation, Hypothesis, Impact, Feasibility, Tradeoffs).

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
resource-reallocation-proposal/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Proposal Components
- Executive summary for decision-makers
- Current state analysis with utilization metrics
- Proposed allocation with clear rationale
- ROI comparison (current vs. proposed)
- Risk assessment and mitigation plans
- Implementation timeline

### Output Formats
- Full proposal document
- Executive summary one-pager
- Risk matrix
- Transition timeline

## Usage Instructions

### For Claude Code

```bash
cp -r resource-reallocation-proposal/ ~/.claude/skills/resource-reallocation-proposal/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
My team has 2 engineers dedicated to an internal tool that's 80% complete
but has no urgent deadline. Meanwhile, we're understaffed on a customer-facing
feature that's blocking a major deal. I need to propose moving those engineers
temporarily without making it seem like the internal tool doesn't matter.

Help me write a reallocation proposal for my director.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
