---
name: resume-job-search-coach
version: 1.0.0
description: Complete job search coaching for resumes, interviews, and networking
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive job search coaching including resume optimization, behavioral interview preparation, and networking message templates.

## Overview

This is a **prompt-only skill** with no scripts to generate. The skill content in SKILL.md provides complete instructions for job search coaching.

**Time to initialize**: ~1 minute (copy only)

## Directory Structure

```
resume-job-search-coach/
├── SKILL.md         # Main skill instructions
└── INIT.md          # This file
```

## Dependencies

None required. This is a prompt-only skill.

## Files to Generate

None. Simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r resume-job-search-coach/ ~/.claude/skills/resume-job-search-coach/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Usage Examples

### Resume Bullet Transformation

```
Here's my current resume. I'm a marketing manager with 5 years of experience targeting Senior Marketing Manager roles at tech companies.

[Paste resume]

Can you rewrite my bullet points with quantified achievements? I know I increased email open rates and reduced ad spend, but I need help making it sound more impactful.
```

### Job-Specific Tailoring

```
Here's my resume and a job posting I want to apply for:

RESUME:
[Paste resume]

JOB POSTING:
[Paste job description]

Please tailor my resume for this specific role. What keywords am I missing? What should I emphasize?
```

### Behavioral Interview Prep

```
I have an interview at Google for a Product Manager role next week. I'm worried about behavioral questions, especially:
- "Tell me about a time you failed"
- "Describe a conflict with a coworker"
- "How do you prioritize competing demands?"

Here are some experiences I can draw from:
- Led a product launch that was delayed due to engineering issues
- Had disagreement with engineering lead about feature scope
- Currently managing 3 products with different stakeholder priorities

Help me build STAR stories for these questions.
```

### Networking Outreach

```
I want to reach out to Sarah Chen, a Senior PM at Stripe. She recently posted about their new payments API.

My background: 4 years in fintech as a software engineer, now wanting to transition to PM.

Can you help me draft a LinkedIn message that's not too salesy but shows genuine interest?
```

### Career Change Resume

```
I'm transitioning from teaching (8 years as high school math teacher) to instructional design in corporate L&D.

Here's my current resume written for teaching positions:
[Paste resume]

How should I reframe my experience for corporate roles? What transferable skills should I highlight?
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_role}}` | Product Manager | The job title you're pursuing |
| `{{industry}}` | technology | Target industry |
| `{{experience_level}}` | mid-level (3-7 years) | Your career stage |
| `{{situation}}` | actively looking | Job search context |

## What This Skill Does

1. **Resume Bullets** - Transforms duty descriptions into achievement statements with metrics
2. **Job Tailoring** - Maps your experience to job requirements, identifies keyword gaps
3. **STAR Stories** - Builds structured stories for behavioral interview questions
4. **Networking** - Crafts cold outreach messages and follow-up sequences
5. **Special Situations** - Handles career changes, gaps, and new graduates

## Best Practices

1. **Be specific** - The more detail you provide, the better the coaching
2. **Include target JD** - For resume work, always share the job description
3. **Share context** - Career changers and gap explainers need different approaches
4. **Iterate** - Refine bullets and stories through conversation
5. **Practice aloud** - STAR stories should be rehearsed, not just written

---
Downloaded from [FindSkill.ai](https://findskill.ai)
