---
name: reward-system-optimizer
version: 1.0.0
---

# Initialization

Design sustainable motivation systems using behavioral science. Build reward structures with small wins, variable reinforcement, and delayed gratification training.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with behavioral design instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r reward-system-optimizer/ ~/.claude/skills/reward-system-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{context}}` | `mobile fitness app` | Platform, app, or program type |
| `{{target_behavior}}` | `daily workout completion` | Specific behavior to reinforce |
| `{{user_profile}}` | `mixed (health + social)` | Primary motivation type |

## Core Concepts Reference

### Reinforcement Schedules
- **Continuous**: Every action rewarded (fast learning, fast extinction)
- **Fixed-Ratio**: Every Nth action (predictable, moderate persistence)
- **Variable-Ratio**: Random 1-N actions (highest engagement, extinction resistant)
- **Fixed-Interval**: Time-based periodic (scalloped response)
- **Variable-Interval**: Random time-based (steady, moderate)

### Reward Types (Hook Model)
- **Tribe**: Social validation, belonging, status
- **Hunt**: Material gains, resources, tangibles
- **Self**: Mastery, achievement, competence

### Key Behavioral Principles
- **Overjustification Effect**: External rewards undermine intrinsic motivation
- **Dopamine Ramping**: Anticipation builds dopamine; waiting is trainable
- **Psychological Momentum**: Small wins compound confidence
- **Reward Satiation**: Repetition reduces effectiveness; variety prevents

### Configuration Parameters
```json
{
  "reward_schedule_type": "variable_ratio",
  "average_reward_frequency": 5,
  "reward_type_rotation": ["tribe", "hunt", "self"],
  "micro_milestone_interval": 7,
  "delayed_gratification_ramp_weeks": 12,
  "progress_visibility_cadence": "weekly"
}
```

## Use Cases

1. **Fitness Apps**: Design workout completion rewards that prevent 4-week dropout
2. **Learning Platforms**: Build course completion incentives with progress visibility
3. **Employee Recognition**: Create sustainable recognition programs avoiding satiation
4. **SaaS Retention**: Design engagement mechanics that maximize lifetime value
5. **Habit Tracking**: Build motivation systems that transfer to intrinsic drive
6. **Gamification Audits**: Diagnose and fix failing reward systems

## Research Sources

This skill synthesizes principles from:
- Nir Eyal's Hook Model for habit-forming products
- B.F. Skinner's operant conditioning theory
- Neuroscience research on dopamine and delayed gratification
- Behavioral economics (overjustification effect, loss aversion)
- Evidence-based gamification design patterns

---
Downloaded from [Find Skill.ai](https://findskill.ai)
