---
name: role-transition-runbook-builder
version: 1.0.0
description: Create comprehensive handoff documentation when changing roles
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps professionals create comprehensive transition documentation using the HANDOFF framework when leaving a position, ensuring smooth knowledge transfer and successor success.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
role-transition-runbook-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## What This Skill Covers

### Transition Document Sections
- Role overview and responsibilities
- Active projects with handoff plans
- Stakeholder relationship maps
- Recurring meetings calendar
- Institutional knowledge capture
- 30-60-90 day successor guide

### Templates Included
- Handoff meeting agenda
- Transition checklist
- Stakeholder introduction plan

## Usage Instructions

### For Claude Code

```bash
cp -r role-transition-runbook-builder/ ~/.claude/skills/role-transition-runbook-builder/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your AI assistant

## Example Request

```
I'm leaving my role as Engineering Manager in 4 weeks to take an
internal promotion. My replacement is being hired externally and
won't start for 2 weeks after I leave. I need to document everything
about my role—ongoing projects, stakeholder relationships, recurring
meetings, and where all the bodies are buried.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

---
Downloaded from [Find Skill.ai](https://findskill.ai)
