---
name: scenario-planning-generator
version: 1.0.0
---

# Scenario Planning Generator - Initialization

An AI-powered strategic planning tool that creates 3-5 plausible future scenarios (bull, base, bear cases) with detailed implications for organizational decision-making under uncertainty.

## Structure

```
scenario-planning-generator/
├── SKILL.md          # Main skill prompt with full methodology
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Core Capabilities

1. **Strategic Scenario Frameworks** - 2x2 matrix methodology, bull/base/bear financial modeling
2. **Environmental Scanning** - PESTLE, Porter's Five Forces, VRIO analysis integration
3. **Early Warning Systems** - Leading indicators and monitoring dashboards
4. **Contingency Planning** - Scenario-specific response playbooks

## Key Frameworks Included

| Framework | Purpose |
|-----------|---------|
| 2x2 Matrix | Create 4 distinct scenarios from 2 critical uncertainties |
| PESTLE | Macro-environmental scanning |
| Porter's Five Forces | Competitive landscape analysis |
| VRIO | Internal capability assessment |
| Bull/Base/Bear | Financial projection scenarios |

## Post-Init Steps

### Claude Code Installation
```bash
cp -r scenario-planning-generator/ ~/.claude/skills/scenario-planning-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{time_horizon_years}}` | `5` | Planning period (3, 5, 7, or 10 years) |
| `{{num_scenarios}}` | `4` | Number of scenarios (3-5) |
| `{{scenario_types}}` | `bull, base, bear, alternative` | Scenario emphasis |
| `{{industry_focus}}` | `general` | Industry lens (technology, healthcare, finance, energy, manufacturing, retail) |
| `{{decision_focus}}` | `strategy` | Decision type (strategy, product, investment, risk, M&A, transformation) |
| `{{quantitative_modeling}}` | `true` | Include financial projections |

## Example Usage

```
I need to develop a 5-year strategic scenario plan for our SaaS company
($50M ARR). We're deciding between geographic expansion (EMEA) versus
vertical expansion (enterprise banking niche).

Create 4 strategic scenarios based on these critical uncertainties:
1. Enterprise adoption of AI in financial services (slow vs. rapid)
2. Our ability to build enterprise-grade compliance capabilities

For each scenario, provide: vivid name and narrative, market size
projections for bull/base/bear sub-cases, competitive positioning
implications, organizational capabilities needed, go-to-market
strategy adaptations, early warning indicators, and decision gates.
```

## Common Workflows

1. **Executive Strategic Planning** (8-12 weeks) - Full scenario exercise with stakeholder workshops
2. **Financial Modeling** (4-6 weeks) - Bull/base/bear financial projections
3. **Product Launch Planning** (6-10 weeks) - Market entry scenario analysis

## Output Formats

- Executive Summary (1-2 pages)
- Full Scenario Report (15-30 pages)
- Monitoring Dashboard (1 page)
- Decision Framework (2-3 pages)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
