---
name: seo-keyword-research
version: 1.0.0
---

# Initialization

SEO Keyword Research skill for discovering high-value keywords, analyzing search intent, conducting competitive gap analysis, and creating data-driven keyword strategies that drive organic traffic and conversions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive keyword research methodology

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. For optimal results, users may benefit from:
- Access to keyword research tools (Ahrefs, Semrush, Moz, or free alternatives)
- Google Search Console access for existing site data
- Google Trends for seasonality analysis

## Post-Init Steps

### Claude Code
```bash
cp -r seo-keyword-research/ ~/.claude/skills/seo-keyword-research/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter
3. Paste into your AI assistant (Claude, ChatGPT, Gemini, Copilot)

## Compatibility

Tested with:
- Claude (Sonnet, Opus)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- GitHub Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{search_volume_minimum}}` | `10` | Minimum monthly search volume threshold for keyword inclusion |
| `{{keyword_difficulty_maximum}}` | `50` | Maximum difficulty score to target (0-100 scale) |
| `{{search_intent_filter}}` | `informational,commercial,transactional` | Intent types to prioritize |
| `{{competitor_count}}` | `5` | Number of competitors to include in gap analysis |
| `{{keyword_minimum_words}}` | `2` | Minimum words in keyword phrase |
| `{{ranking_position_target}}` | `3` | Target ranking position goal (top 3, top 5, top 10) |

## Core Capabilities

1. **Keyword Discovery & Expansion** - Find keywords using seed expansion, modifiers, and question mining
2. **Search Intent Analysis** - Classify keywords by intent type and the three Cs framework
3. **Competitive Gap Analysis** - Identify keywords competitors rank for that you don't
4. **Keyword Metrics Assessment** - Evaluate volume, difficulty, CPC, and click potential
5. **Long-tail Keyword Mining** - Find low-competition, high-conversion opportunities
6. **Keyword Clustering & Mapping** - Organize keywords strategically for content planning

## Example Usage

```
I run an e-commerce site selling sustainable yoga mats. My competitors are
Manduka, Liforme, and Lululemon. I want to find keywords they rank for that
I don't, with at least 50 monthly searches but a difficulty score below 40
so I can rank within 3 months. Focus on long-tail keywords that emphasize
eco-friendly or sustainable angles.
```

## Research Sources

This skill is based on methodology from:
- Moz Beginners Guide to SEO
- Ahrefs Search Intent Guide
- Semrush Keyword Gap Analysis Guide
- Surfer SEO Long-tail Keywords Guide
- Brafton's 8-Step Keyword Research Process

---
Downloaded from [Find Skill.ai](https://findskill.ai)
