---
name: side-income-prioritizer
version: 1.0.0
---

# Initialization

Side Income Prioritizer helps entrepreneurs, freelancers, and professionals with multiple income streams determine where to allocate their limited time for maximum return. It uses ROE analysis, BCG Matrix classification, and Pareto principle to prioritize existing income sources.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive income stream analysis frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r side-income-prioritizer/ ~/.claude/skills/side-income-prioritizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{min_roe_threshold}}` | `2.0` | Minimum acceptable ROE ratio before elimination |
| `{{pareto_focus_percentage}}` | `20` | Percentage of effort for top performers |
| `{{evaluation_period_months}}` | `6` | Historical lookback period for ROE |
| `{{effort_hourly_value}}` | `50` | Dollar value per hour of your time |
| `{{scalability_multiplier_target}}` | `2.5` | Growth multiple for Star classification |
| `{{platform_dependency_risk_factor}}` | `0.7` | Risk multiplier for single-platform streams |

## Core Capabilities

1. **ROE Calculation** - Calculate Return on Effort for each income stream
2. **BCG Matrix** - Classify streams as Stars, Cash Cows, Question Marks, or Dogs
3. **Pareto Analysis** - Identify vital few streams delivering 80% of returns
4. **Opportunity Cost** - Quantify foregone income from misallocated effort
5. **Decision Matrix** - Weighted multi-criteria evaluation for new opportunities
6. **Scenario Planning** - Model 6-12 month projections for different allocations
7. **Risk Assessment** - Evaluate and adjust for platform dependency

## Example Usage

```
I have four income streams:
1. Freelance copywriting: $3,000/month, 40 hrs/week
2. YouTube channel: $500/month, 10 hrs/week
3. Affiliate marketing: $1,200/month, 8 hrs/week
4. Consulting retainer: $2,000/month, 15 hrs/week

My goal is to maximize total income while reducing hours.
Create a BCG matrix and recommend where to focus.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
