---
name: skill-gap-analyzer
version: 1.0.0
---

# Initialization

Skill Gap Analyzer - A comprehensive career development tool that helps professionals identify the gap between their current abilities and career aspirations, then creates prioritized, actionable development roadmaps with ROI analysis.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive instructions for career gap analysis

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r skill-gap-analyzer/ ~/.claude/skills/skill-gap-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

Works best with AI assistants that support:
- Long-form responses
- Structured output formatting
- Multi-turn conversations

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{career_goal}}` | `Senior Software Engineer` | Target role or position you're working toward |
| `{{proficiency_scale}}` | `1-5` | Rating system for skill assessment (1-5, 1-10, Beginner-Expert) |
| `{{assessment_timeframe}}` | `quarterly` | How frequently to reassess skills |
| `{{priority_metric}}` | `impact_score` | How to rank skill gaps (impact_score, frequency, importance, market_demand) |
| `{{learning_format}}` | `blended` | Preferred learning delivery method |
| `{{timeline_constraint}}` | `12_months` | Available time to close skill gaps |

## Usage Examples

### Individual Career Assessment
```
I'm a marketing specialist with 5 years of experience. I want to become a Marketing Manager within 12 months. My strong skills: social media strategy, content creation, analytics. Weaker areas: budgeting, strategic planning, vendor management. Analyze my gaps and create a development roadmap.
```

### Career Pivot Analysis
```
I'm a mechanical engineer with 8 years in automotive. I want to transition to robotics engineering. Assess my transferable skills, identify what I need to learn, and tell me if this transition is feasible in 12-18 months.
```

### Team Skills Audit
```
I manage a team of 6 data analysts. We're shifting toward AI-driven decision making. Current team skills: SQL, Excel, Tableau, statistical analysis. Skills we need: Python, ML fundamentals, AI model interpretation. Assess our team gaps and recommend training vs. hiring strategy.
```

## Key Features

- **7 Core Capabilities**: Individual assessment, benchmarking, prioritized learning, career path visualization, ROI analysis, organizational mapping, transition planning
- **5 Ready-to-Use Workflows**: Quick assessment (15 min), comprehensive analysis (60 min), pivot assessment, team audit, annual review
- **Impact-Based Prioritization**: Scores gaps on frequency, importance, and market demand
- **Skill Dependency Mapping**: Ensures foundational skills are developed before advanced ones
- **Visual Output Formats**: Skills matrix, development roadmap, ROI analysis tables

---
Downloaded from [Find Skill.ai](https://findskill.ai)
