---
name: slack-tone-polisher
version: 1.0.0
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
---

# Slack Tone Polisher - Initialization

Transform emotionally-charged Slack messages into professional, constructive communications. This skill detects frustration, passive-aggression, and harsh language, then provides multiple professionally rewritten alternatives while preserving your core message intent.

## Package Contents

```
slack-tone-polisher/
├── SKILL.md    # Main skill prompt (paste into AI assistant)
└── INIT.md     # This initialization file
```

## Quick Start

### Claude Code / Claude Projects

```bash
# Copy to Claude Code skills directory
cp -r slack-tone-polisher/ ~/.claude/skills/slack-tone-polisher/
```

Then reference in your conversations or add to project instructions.

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter block
3. Paste into:
   - **ChatGPT:** Custom Instructions or GPT Builder
   - **Gemini:** Gems configuration
   - **Copilot:** Custom agent or conversation starter

### Direct Use

Simply paste the SKILL.md content at the start of any conversation and begin sharing messages to polish.

## Core Capabilities

| Capability | Description |
|------------|-------------|
| Tone Detection | Identifies frustration, passive-aggression, bluntness, and unclear messaging |
| Multi-variant Rewrites | Provides 3-4 alternative versions with different tones |
| Recipient Awareness | Adjusts suggestions for peers, managers, executives, clients |
| De-escalation Mode | Helps recover from already-sent problematic messages |
| Culture Matching | Adapts to startup, corporate, or creative communication styles |

## Variables

| Variable | Default | Options |
|----------|---------|---------|
| `{{sensitivity_threshold}}` | `0.65` | 0.0-1.0 (lower = more alerts) |
| `{{tone_preference}}` | `professional_collaborative` | formal, direct, empathetic, solutions_focused, casual_professional |
| `{{recipient_type}}` | `peer` | peer, manager, executive, client, team |
| `{{culture_preset}}` | `standard` | startup_casual, standard, corporate_formal, creative_relaxed |
| `{{max_variants}}` | `4` | 1-6 rewrite options |

## Usage Examples

### Basic Tone Polish

```
User: Polish this message:

"This is RIDICULOUS. The API is broken AGAIN and nobody seems to care."

AI: [Provides analysis and 3-4 professional alternatives]
```

### With Recipient Context

```
User: Polish this for my skip-level manager:

"We've been asking for more headcount for months and nothing happens."

AI: [Provides executive-appropriate alternatives with business framing]
```

### Emergency De-Escalation

```
User: I already sent this and the person seems upset. How do I fix it?

"Your approach is wrong. Redo it."

AI: [Provides follow-up message options to smooth things over]
```

## Tone Transformation Reference

| Original Tone | Target Tone | Key Change |
|---------------|-------------|------------|
| Frustrated/Annoyed | Professional Concern | Business impact + collaboration |
| Passive-Aggressive | Direct & Respectful | Explicit issue + path forward |
| Blunt/Harsh | Empathetic & Collaborative | I-statements + help offer |
| Unclear/Demanding | Clear & Contextual | Ask + context + deadline |
| Negative/Dismissive | Solutions-Focused | Constraint + alternatives |

## Trigger Words to Watch

These words often signal tone issues:

- **Remove:** obviously, clearly, just, simply, again
- **Replace with specifics:** always, never, ASAP
- **Soften:** wrong, failed, problem
- **Clarify:** fine, whatever, sure

## Integration Tips

### Slack Workflow Ideas

1. **Pre-send check:** Before sending important messages, paste draft for review
2. **Weekly reflection:** Review sent messages from stressful weeks for patterns
3. **Team coaching:** Share polished alternatives in 1:1s to build communication skills

### Combine With

- **Assertive Communication Coach** - Build underlying communication confidence
- **Conflict Resolver** - Handle situations that escalate beyond messaging
- **Async Communication Guide** - Master written communication broadly

## Troubleshooting

**AI flags my message but it's actually fine:**
- Increase `{{sensitivity_threshold}}` to 0.8+
- Add context: "This person and I have a direct communication style"

**Suggestions sound too corporate/stiff:**
- Change `{{culture_preset}}` to `startup_casual` or `creative_relaxed`
- Specify: "Keep my authentic voice, just soften the edges"

**Not enough options provided:**
- Increase `{{max_variants}}` to 5 or 6
- Ask: "Give me more alternatives ranging from formal to casual"

## Best Practices

1. **Share context** - The more the AI knows about the situation, the better the suggestions
2. **Specify recipient** - Manager vs. peer vs. client makes a big difference
3. **State your goal** - "I want action" vs. "I want to vent professionally" vs. "I need to de-escalate"
4. **Review before sending** - AI suggestions are starting points; make them yours
5. **Learn patterns** - Notice which trigger words appear in your drafts repeatedly

---

Downloaded from [Find Skill.ai](https://findskill.ai)
