---
name: sleep-quality-debugger
version: 1.0.0
---

# Initialization

Sleep Quality Debugger is an evidence-based diagnostic framework for sleep disorders. It uses validated clinical tools (PSQI, ISI, AIS) to systematically diagnose sleep problems and builds personalized, multi-phase recovery protocols using CBT-I, stimulus control, sleep restriction, and environmental optimization.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete diagnostic and intervention framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r sleep-quality-debugger/ ~/.claude/skills/sleep-quality-debugger/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{psqi_cutoff}}` | `5` | PSQI score threshold for poor sleep classification |
| `{{caffeine_halflife_hours}}` | `5.5` | Caffeine half-life in hours for dose-timing calculations |
| `{{optimal_temp_celsius}}` | `22` | Target bedroom temperature in Celsius |
| `{{sleep_efficiency_target}}` | `85` | Target sleep efficiency percentage |
| `{{recovery_protocol_weeks}}` | `12` | Default duration for full recovery protocol |
| `{{caffeine_cutoff_hours}}` | `6` | Hours before bedtime to stop caffeine |

## Key Features

### Diagnostic Tools
- **PSQI (Pittsburgh Sleep Quality Index)**: 19-item gold-standard assessment with 89.6% sensitivity
- **ISI (Insomnia Severity Index)**: 7-item rapid insomnia quantification
- **AIS (Athens Insomnia Scale)**: 8-item alternative assessment

### Assessment Domains
1. **Circadian Rhythm Analysis**: Chronotype assessment, light exposure audit, phase alignment
2. **Caffeine Pharmacokinetics**: Dose-timing modeling, half-life calculations, reduction protocols
3. **Environmental Audit**: Temperature, humidity, light, noise, air quality targets
4. **Psychological Factors**: Hyperarousal patterns, cognitive distortions, stress-sleep pathways

### Intervention Protocols
- **Stimulus Control Therapy (SCT)**: Gold-standard behavioral intervention
- **Sleep Restriction Therapy (SRT)**: Sleep consolidation through time-in-bed restriction
- **Cognitive Therapy**: Worry management, cognitive restructuring
- **Intensive Sleep Re-Training (ISR)**: 24-hour rapid protocol for severe cases

### Recovery Framework
- Phase 1 (Weeks 1-2): Environmental optimization + behavioral foundation
- Phase 2 (Weeks 2-4): Stimulus control + sleep restriction
- Phase 3 (Weeks 4-8): Cognitive therapy + relaxation
- Phase 4 (Weeks 8-12+): Maintenance + relapse prevention

## Research Sources

This skill is based on peer-reviewed research including:
- Pittsburgh Sleep Quality Index (PSQI) validation studies
- Frontiers in Neurology comparison of insomnia assessment tools
- PMC reviews on caffeine pharmacology and sleep-wake regulation
- Evidence-based CBT-I intervention studies with effect sizes d > 0.8
- Environmental sleep optimization research

---
Downloaded from [Find Skill.ai](https://findskill.ai)
