---
name: student-loan-payoff-strategist
version: 1.0.0
description: Optimize student loan repayment using Snowball, Avalanche, or Hybrid strategies with PSLF and IDR plan analysis
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

The Student Loan Payoff Strategist is a prompt-based skill that helps borrowers optimize their student loan repayment by balancing mathematical efficiency with psychological sustainability. It covers federal vs. private loans, PSLF eligibility, income-driven repayment plans, and refinancing decisions.

**Time to initialize**: ~1 minute (prompt-only skill)

## What This Skill Provides

- **Strategy comparison**: Snowball vs. Avalanche vs. Debt-to-Interest Ratio Hybrid
- **PSLF analysis**: Eligibility assessment and forgiveness value calculation
- **IDR plan guidance**: SAVE, PAYE, IBR, ICR comparison and recommendations
- **Refinancing evaluation**: Federal-to-private trade-off framework
- **Psychological assessment**: Motivation profile matching to optimal strategy
- **Biweekly payment optimization**: Interest savings calculations

## Directory Structure

```
student-loan-payoff-strategist/
├── SKILL.md    # Main skill instructions (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Simply use SKILL.md directly.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r student-loan-payoff-strategist/ ~/.claude/skills/student-loan-payoff-strategist/
```

Then reference the skill in conversations:
- "Use the student-loan-payoff-strategist skill to analyze my loans"
- "Help me with student loan payoff strategy"

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Start providing your loan details

## Compatibility

Tested with:
- Claude (Sonnet, Opus)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Copilot

## Variables

Customize these parameters when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{strategy_preference}}` | `hybrid` | Payoff approach: snowball, avalanche, or hybrid |
| `{{monthly_extra_payment}}` | `$500` | Extra monthly payment beyond minimums |
| `{{pslf_eligible}}` | `unknown` | Public service employment status |
| `{{loan_types}}` | `federal` | Federal, private, or mixed loan portfolio |
| `{{motivation_level}}` | `medium` | Psychological profile: low, medium, or high |
| `{{biweekly_payments}}` | `false` | Whether to model biweekly payment optimization |

## Example Usage

After initialization, try prompts like:

**Basic strategy selection:**
```
I have three federal student loans: $8,000 at 4.45%, $15,000 at 5.50%,
and $22,000 at 6.85%. My take-home is $3,200/month, and I can afford
to put an extra $300/month toward loans. I'm not going into public
service, so PSLF doesn't apply. Compare all my options.
```

**Refinancing evaluation:**
```
I have $45,000 in federal student loans at an average 5.8% rate.
A private lender is offering to refinance at 4.5%. I'm 2 years into
qualifying PSLF payments at a nonprofit. Should I refinance?
```

**Married couple optimization:**
```
My spouse and I have combined student loans: I owe $35,000 at 6.2%
and they owe $28,000 at 4.1%. We're getting a $12,000 annual bonus.
What's the optimal strategy for our household?
```

## Key Features

### Strategy Comparison
- Snowball (quick wins first)
- Avalanche (mathematically optimal)
- Debt-to-Interest Ratio Hybrid (balanced approach)
- Side-by-side timeline and interest comparisons

### PSLF Analysis
- Eligibility verification
- Forgiveness value calculation
- Comparison to aggressive payoff cost
- ECF submission reminders

### IDR Plan Guidance
- SAVE, PAYE, IBR, ICR comparison
- Payment calculations based on discretionary income
- Forgiveness timeline projections
- When IDR beats aggressive payoff

### Refinancing Framework
- Federal protection loss assessment
- Rate improvement calculations
- Break-even analysis
- Stability requirements

### Psychological Matching
- Math Optimizer profile → Avalanche
- Early-Win Seeker profile → Snowball
- Balanced Pragmatist profile → Hybrid
- Avoidant profile → Automated Snowball

## Research Foundation

This skill's recommendations are based on peer-reviewed research:

- Mixed-integer optimization saves 4% more than traditional methods
- Proportional balance reduction drives motivation more than absolute dollars
- Reducing debt accounts improves cognition and reduces anxiety
- Behavioral nudges reduce delinquencies by 0.4 percentage points
- Hybrid strategies achieve 75-85% adherence vs. 35-40% for Avalanche

## Verification

After setup, verify the skill is working by asking:
- "What are the three main student loan payoff strategies?"
- "How do I know if PSLF is worth pursuing?"
- "What should I consider before refinancing federal loans?"

The AI should respond with detailed, research-backed guidance covering Snowball, Avalanche, Hybrid strategies, PSLF eligibility criteria, and federal-to-private refinancing trade-offs.

---
Downloaded from [FindSkill.ai](https://findskill.ai)
