---
name: symptom-health-researcher
version: 1.0.0
description: Health research assistant for symptoms, medical terms, doctor preparation, and lab results
author: FindSkill.ai
license: MIT
---

# Initialization

This skill helps users research health symptoms, understand medical terminology, prepare for doctor visits, and interpret lab results—all in plain language without replacing professional medical advice.

## Overview

**What this skill does:**
- Explains symptoms and medical terms in plain language
- Helps prepare questions for doctor visits
- Provides basic lab result interpretation
- Identifies red flag symptoms requiring immediate care
- Links to reliable health resources

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
symptom-health-researcher/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r symptom-health-researcher/ ~/.claude/skills/symptom-health-researcher/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{symptom_description}}` | "" | Primary symptom or health concern |
| `{{duration}}` | "recent" | How long the symptom has been present |
| `{{severity}}` | "mild" | Severity level (mild, moderate, severe) |
| `{{medical_history}}` | "" | Relevant medical history or conditions |

## Example Usage

**Basic symptom research:**
> "I've had a persistent headache for 3 days, mostly on one side, with some nausea. Help me understand what this might be and prepare questions for my doctor."

**Lab result interpretation:**
> "My recent blood test showed TSH at 5.2 mIU/L and the reference range says 0.4-4.0. What does this mean in plain language?"

**Medical term translation:**
> "My doctor said I have 'bilateral otitis media with effusion.' Can you explain what that means?"

**Doctor visit preparation:**
> "I'm seeing my doctor tomorrow about recurring stomach pain. Help me prepare a list of questions and what information I should bring."

## Key Features

1. **Plain language explanations** - No medical jargon without translation
2. **Red flag identification** - Always flags emergency symptoms
3. **AHRQ question framework** - Evidence-based doctor communication
4. **Lab reference ranges** - Common tests explained simply
5. **Symptom tracking templates** - Structured tracking for patterns
6. **Reliable source links** - MedlinePlus, Mayo Clinic, etc.

## Safety Guardrails

This skill includes critical safety features:
- Clear disclaimer that it's not medical advice
- Always recommends consulting healthcare providers
- Immediate flagging of emergency symptoms
- Crisis resources (911, 988 Suicide & Crisis Lifeline)
- Never attempts to diagnose or recommend treatments

## Verification

To verify the skill is working correctly:
1. Ask about a common symptom (e.g., "What causes headaches?")
2. Confirm the response includes the disclaimer
3. Confirm it suggests seeing a healthcare provider
4. Confirm it provides educational information without diagnosing

---

Downloaded from [FindSkill.ai](https://findskill.ai)
