---
name: team-charter-creator
version: 1.0.0
description: Generate comprehensive team charters with RACI matrices, working agreements, and governance frameworks
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps project managers, team leads, and executives create comprehensive team charters for new teams and cross-functional initiatives. It covers everything from mission statements to decision-making frameworks.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
team-charter-creator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## What This Skill Covers

### Charter Components
- Mission and vision statements
- Scope definition (in/out of scope)
- Team composition and roles
- RACI responsibility matrices
- Working agreements and norms
- Decision-making frameworks
- Communication protocols
- Success metrics and KPIs
- Stakeholder mapping

### Use Cases
- Forming new project teams
- Creating cross-functional working groups
- Establishing task forces
- Spinning up product teams
- Defining governance for initiatives

## Usage Instructions

### For Claude Code

```bash
# Copy to your skills directory
cp -r team-charter-creator/ ~/.claude/skills/team-charter-creator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

### Quick Start

Tell the AI:
- Team name and purpose
- Number and roles of team members
- Timeline and key deliverables
- Sponsor/executive oversight
- What charter sections you need

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{team_name}}` | Platform Migration Team | Team or project name |
| `{{team_size}}` | 8 people | Number of members |
| `{{team_purpose}}` | migrate legacy systems | Primary mission |
| `{{duration}}` | 6 months | Expected timeline |

## Example Request

```
I'm forming a new cross-functional team to build our mobile app. We have
6 people from Engineering, Design, and Product. The project will run for
4 months. I need a team charter that includes:
- Mission statement
- RACI matrix for key deliverables
- Working agreements for remote collaboration
- Decision-making framework

The team reports to the VP of Product.
```

## RACI Quick Reference

| Letter | Role | Meaning |
|--------|------|---------|
| R | Responsible | Does the work |
| A | Accountable | Final authority (ONE only) |
| C | Consulted | Input before work |
| I | Informed | Updated after |

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Post-Init Verification

After setup, test with: "Help me create a team charter for a new 5-person product team that will build our customer portal over the next 3 months."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
