---
name: team-charter-creator
description: Generate comprehensive team charters with mission statements, RACI matrices, working agreements, and decision-making frameworks. Use when forming new teams, cross-functional projects, or working groups.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: intermediate
variables:
  - name: "team_name"
    default: "Platform Migration Team"
    description: "Name of the team or project"
  - name: "team_size"
    default: "8 people"
    description: "Number of team members"
  - name: "team_purpose"
    default: "migrate legacy systems to cloud"
    description: "Primary mission"
---

# Team Charter Creator

Generate comprehensive team charters for new teams and cross-functional initiatives.

## Quick Start

Tell me about your team:
- Team name and purpose
- Number and roles of team members
- Project timeline and key deliverables
- Who the team reports to (sponsor)

I'll generate a complete charter with mission, RACI, and working agreements.

## What This Skill Creates

### Core Charter Components
- Mission and vision statements
- Scope definition (in/out of scope)
- Team composition and roles
- RACI matrix for key deliverables

### Governance Framework
- Working agreements and team norms
- Decision-making framework with authority levels
- Communication protocols and channels
- Escalation paths

### Success Tracking
- KPIs and success metrics
- Milestone timeline
- Risk register
- Stakeholder map

## RACI Quick Reference

| Role | Definition |
|------|------------|
| **R** - Responsible | Does the work |
| **A** - Accountable | Ultimately answerable (ONE only) |
| **C** - Consulted | Provides input before |
| **I** - Informed | Kept updated after |

## Working Agreement Categories

- **Communication**: Response times, channels, async norms
- **Meetings**: Cadence, preparation, documentation
- **Collaboration**: Feedback, escalation, help-seeking
- **Quality**: Definition of done, review standards

## Decision Framework Levels

1. **Individual**: Day-to-day within role
2. **Team**: Affects multiple members
3. **Escalation**: Cross-team or strategic impact

---
Downloaded from [Find Skill.ai](https://findskill.ai)
