---
name: town-hall-announcement-writer
version: 1.0.0
description: Generate professional all-hands meeting announcements with complete communication packages
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps executives, HR leaders, and internal communications teams create comprehensive town hall communication packages. It covers the complete meeting lifecycle from announcement to follow-up.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
town-hall-announcement-writer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None (prompt-only skill)

## Files to Generate

None - this is a prompt-only skill. Copy SKILL.md content directly to your AI assistant.

## What This Skill Covers

### Pre-Meeting Communications
- Save-the-date announcements
- Detailed agenda invitations
- Reminder sequences
- Question collection prompts

### Meeting Preparation
- Key message frameworks
- Q&A anticipation documents
- Difficult question handling
- Speaker talking points

### Post-Meeting Follow-up
- Summary emails
- Recording distribution
- Action item tracking
- Feedback surveys

## Usage Instructions

### For Claude Code

```bash
# Copy to your skills directory
cp -r town-hall-announcement-writer/ ~/.claude/skills/town-hall-announcement-writer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

### Quick Start

Tell the AI:
- Meeting type (quarterly all-hands, department town hall, etc.)
- Expected audience size
- Key agenda topics
- Any sensitive issues to address

The AI will generate appropriate communications for your meeting lifecycle.

## Customization Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{meeting_type}}` | quarterly all-hands | Type of town hall |
| `{{audience_size}}` | 150 employees | Expected attendance |
| `{{company_name}}` | Acme Corp | Your organization |
| `{{key_topics}}` | Q3 results, roadmap, recognition | Main agenda items |

## Example Request

```
I'm the VP of Operations and need to announce our quarterly town hall
next Thursday. We'll cover Q3 financial results, the new product roadmap
for 2026, and recognize the customer success team. About 200 people will
attend virtually. Help me create the pre-meeting announcement, prepare
for likely Q&A questions, and draft the follow-up summary template.
```

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

## Post-Init Verification

After setup, test with: "Help me create a save-the-date announcement for our quarterly all-hands meeting next month covering company results and team recognition."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
