---
name: town-hall-announcement-writer
description: Generate professional all-hands meeting announcements with pre-meeting notices, key message frameworks, Q&A preparation, and post-meeting summaries. Use when planning corporate town halls, quarterly all-hands meetings, or leadership updates.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: intermediate
variables:
  - name: "meeting_type"
    default: "quarterly all-hands"
    description: "Type of town hall meeting"
  - name: "audience_size"
    default: "150 employees"
    description: "Expected attendance"
  - name: "company_name"
    default: "Acme Corp"
    description: "Organization name"
---

# Town Hall Announcement Writer

Generate complete communication packages for corporate town hall meetings and all-hands announcements.

## Quick Start

Tell me about your upcoming town hall:
- What type of meeting? (quarterly all-hands, department town hall, special announcement)
- How many attendees?
- What are the key topics?
- Any sensitive issues to address?

I'll generate the appropriate communications for your meeting lifecycle.

## What This Skill Creates

### Pre-Meeting Communications
- Save-the-date announcements (2-3 weeks out)
- Detailed agenda invitations (1 week out)
- Reminder series (day before, hour before)
- Question collection prompts

### Meeting Preparation
- Key message frameworks (3-3-3 structure)
- Q&A anticipation documents
- Difficult question handling guides
- Speaker talking points

### Post-Meeting Follow-up
- Summary emails with key highlights
- Recording distribution
- Action item tracking
- Feedback survey prompts

## Town Hall Lifecycle Framework

```
BEFORE (2-3 weeks)        DURING                 AFTER (48 hours)
├─ Save-the-Date          ├─ Opening Script      ├─ Summary Email
├─ Detailed Invite   -->  ├─ Transitions    -->  ├─ Recording Link
├─ Q&A Collection         ├─ Q&A Facilitation    ├─ Action Items
└─ Reminder Series        └─ Closing Remarks     └─ Feedback Survey
```

## Key Message Framework

For each major topic, use the 3-3-3 structure:

**3 Key Points** - What you MUST communicate
**3 Supporting Facts** - Evidence for each point
**3 Anticipated Questions** - Prepare for pushback

## Q&A Preparation Categories

Prepare responses for these common question types:
- Business Performance (metrics, targets, competition)
- Strategy & Direction (priorities, changes, market position)
- People & Culture (headcount, policies, concerns)
- Operations & Resources (tools, processes, investments)

## Best Practices

### Timing
- Quarterly company-wide: 60-90 minutes
- Monthly department: 45-60 minutes
- Mid-week scheduling (Tue-Thu) for best attendance
- Consider global time zones

### Engagement
- Collect questions in advance
- Use live polls during presentation
- Dedicate 30%+ of time to Q&A
- Send recording within 24 hours

### Communication Tone
| Announcement Type | Tone |
|-------------------|------|
| Business update | Clear, confident, data-driven |
| Recognition | Enthusiastic, specific, celebratory |
| Difficult news | Empathetic, honest, forward-looking |
| Strategy changes | Direct, contextual, action-oriented |

## Example Output

When you provide meeting details, I'll generate:

1. **Save-the-Date Email** - Brief, calendar-focused
2. **Detailed Invitation** - Full agenda with timing
3. **Q&A Preparation Doc** - Anticipated questions with responses
4. **Post-Meeting Summary** - Recap with action items

---
Downloaded from [Find Skill.ai](https://findskill.ai)
