---
name: vertical-integration-evaluator
version: 1.0.0
---

# Vertical Integration Evaluator - Initialization

Analyze make-or-buy decisions using transaction cost economics, assess supply chain integration opportunities, and build implementation roadmaps with ROI projections.

## What This Skill Does

This skill transforms your AI assistant into an expert strategic advisor for vertical integration analysis. It helps you:

- **Evaluate Make-or-Buy Decisions**: Apply transaction cost economics to determine whether to integrate or outsource specific supply chain functions
- **Assess Integration Opportunities**: Use McKinsey's four criteria framework to identify valid integration cases vs. spurious motivations
- **Build Implementation Roadmaps**: Create phased integration plans with realistic timelines and success metrics
- **Monitor Post-Integration Performance**: Track KPIs and identify corrective actions for underperforming integrations
- **Compare Strategic Scenarios**: Model integration vs. outsourcing vs. status quo with financial projections

## Structure

```
vertical-integration-evaluator/
├── SKILL.md          # Main skill prompt with complete methodology
└── INIT.md           # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r vertical-integration-evaluator/ ~/.claude/skills/vertical-integration-evaluator/
```

Then reference in conversations: "Use the vertical-integration-evaluator skill to analyze..."

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your Custom GPT's instructions or conversation

### Other AI Assistants

1. Open `SKILL.md`
2. Copy the complete prompt content
3. Paste at the start of your conversation or into system instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{asset_specificity_score}}` | `5` | Degree to which investments are specific to the relationship (1-10 scale) |
| `{{integration_scope_percent}}` | `50` | Percentage of supply chain stage to integrate (0-100%) |
| `{{supplier_bargaining_power_index}}` | `5` | Relative negotiating strength of suppliers (1-10, 10 = supplier dominates) |
| `{{market_uncertainty_volatility}}` | `5` | Environmental volatility affecting price/demand (1-10) |
| `{{internal_capability_maturity}}` | `6` | In-house capability to manage integrated operations (1-10) |
| `{{capital_availability_millions}}` | `50` | Available capital for integration investment in millions |
| `{{complexity_overhead_multiplier}}` | `1.3` | Organizational overhead factor (1.0 = none, 1.5+ = severe) |

## Key Frameworks Included

### 1. Transaction Cost Economics
- Asset specificity analysis (site, physical, human, dedicated, brand, temporal)
- Ex-ante and ex-post transaction cost evaluation
- Opportunism and bounded rationality assessment

### 2. McKinsey's Four Criteria
- Vertical market failure
- Supplier/buyer power imbalance
- Market power creation
- Market development needs

### 3. Decision Workflows
- Strategic Integration Feasibility Assessment
- Make-or-Buy Analysis for Specific Functions
- Implementation Roadmap Development
- Post-Integration Performance Monitoring
- Scenario Comparison Framework

### 4. Case Studies
- Successful: Tesla (batteries), Apple (retail), SpaceX (manufacturing)
- Failed: Intel (IDM model), Ford (over-integration), Boeing (outsourcing)

## Example Usage

```
I'm a CFO at a mid-sized electronics company. We currently source circuit
boards from three external suppliers, but lead times are unpredictable
(8-12 weeks variance), and suppliers recently raised prices 15%. Circuit
boards represent 35% of our product cost and are critical to our product
differentiation. Our engineers have some circuit design expertise internally.
We have $40 million available for capital investment over 3 years.

Should we integrate backward to acquire one of our suppliers, or negotiate
longer-term contracts with current suppliers? Analyze the trade-offs using
transaction cost economics principles, and help us decide.
```

## Related Skills

- **Competitive Analysis Framework** - Assess competitive landscape before integration
- **Financial Projections Generator** - Model integration investment returns
- **Supply Chain Risk Analyzer** - Identify vulnerabilities justifying integration
- **Due Diligence Checklist Generator** - Comprehensive M&A evaluation

## Industry Applications

| Industry | Common Pattern | Key Considerations |
|----------|----------------|-------------------|
| Manufacturing | Backward into components | Equipment specificity, IP protection |
| Technology | Forward into distribution | Platform control, developer ecosystem |
| Healthcare | Integrated delivery networks | Regulatory complexity, care coordination |
| Retail | Direct-to-consumer | Brand experience, channel conflict |
| E-commerce | Full vertical integration | Capital intensity, customer relationship |

## Best Practices

1. **Always apply McKinsey's four criteria** before recommending integration
2. **Calculate complexity overhead** using realistic multipliers (1.3-1.5x)
3. **Consider quasi-integration** alternatives (alliances, JVs, long-term contracts)
4. **Monitor the inverted U-curve** - optimal integration level exists
5. **Focus on core competencies** - only integrate what matters strategically

## Research Sources

This skill is based on research from:
- McKinsey & Company strategy frameworks
- Transaction cost economics (Williamson)
- Resource-based view of the firm
- Empirical studies of 434+ manufacturing firms
- Case studies from Tesla, Apple, SpaceX, Intel, Ford, Boeing

---
Downloaded from [Find Skill.ai](https://findskill.ai)
