---
name: wealth-gap-analyzer
version: 1.0.0
---

# Initialization

Analyze the gap between income and net worth to identify spending leaks, optimize asset allocation, and accelerate wealth building with actionable, prioritized recommendations.

## Overview

**Wealth Gap Analyzer** examines the disparity between what you earn and what you've accumulated to identify inefficiencies in wealth building. It addresses a fundamental financial paradox: high earners often have lower-than-expected net worth due to spending leakage, lifestyle inflation, and suboptimal asset allocation.

### Key Capabilities
- Calculate and benchmark income-to-wealth ratio by age/income cohort
- Detect and quantify spending leaks (subscriptions, fees, impulse spending)
- Analyze asset allocation vs. age-appropriate recommendations
- Model cash flow patterns and identify timing misalignments
- Provide prioritized wealth optimization recommendations
- Project net worth under multiple optimization scenarios

### Target Users
- High-income professionals (doctors, lawyers, executives, tech workers)
- Entrepreneurs with variable income
- Self-directed investors optimizing financial position
- Young professionals starting wealth-building journey
- Anyone concerned about income-wealth gap disconnect

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive wealth analysis instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None - this is a standalone conversational skill

## Post-Init Steps

### Claude Code
```bash
# Copy to Claude Code skills directory
cp -r wealth-gap-analyzer/ ~/.claude/skills/wealth-gap-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial instruction

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

All major AI assistants can execute this skill effectively. The skill uses standard financial calculations and provides structured output formats that work across platforms.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{annual_income}}` | `75000` | Gross annual income for ratio calculations |
| `{{spending_leak_threshold}}` | `50` | Minimum monthly amount to flag as potential leak |
| `{{savings_rate_target}}` | `0.20` | Target savings percentage (20% default) |
| `{{inflation_rate_assumption}}` | `0.03` | Assumed inflation for real purchasing power |
| `{{portfolio_return_assumption}}` | `0.07` | Assumed investment return (7% default) |
| `{{emergency_fund_months}}` | `6` | Target emergency fund in months of expenses |

## Example Usage

**Prompt 1: Full Wealth Gap Analysis**
```
I earn $150,000 per year but my net worth is only $180,000 at age 35. I have a $400,000 house with $250,000 mortgage, $50,000 in retirement accounts, $20,000 in investments, and $10,000 cash. I spend about $8,500/month. Can you help me understand why my net worth isn't growing faster and what I should focus on?
```

**Prompt 2: Spending Leak Detection**
```
I run a business earning $200K-$300K per year but income is unpredictable. My net worth is $450,000 at age 42. I notice I have a lot of recurring payments but haven't tracked them. Can you identify where my money is leaking and help me stabilize my cash flow?
```

**Prompt 3: Young Professional Starting Out**
```
I just got my first job earning $65,000/year. I have $2,000 in savings, $15,000 in student loans, and live in an apartment. I want to understand the wealth-building game and make smart decisions early. What should I prioritize to maximize long-term wealth?
```

## Research Sources

This skill was developed using research from:
- Federal Reserve wealth gap analysis and benchmarks
- Pew Research Center income-to-wealth studies
- Survey of Consumer Finances (SCF) methodology
- Academic research on behavioral finance and spending patterns
- Financial planning industry standards and best practices

## Related Skills

- **Net Worth Tracker** - Calculate and track net worth over time
- **Budget Planner** - Create budgets after identifying spending leaks
- **Expense Categorizer** - Categorize transactions to find patterns
- **Cash Flow Projector** - Model future income and expenses
- **Retirement Planner** - Long-term wealth accumulation planning
- **Money Anxiety Decoder** - Address psychological barriers to wealth

---
Downloaded from [Find Skill.ai](https://findskill.ai)
