# First-Time Homebuyer Guide - Initialization Manifest

## Skill Identity

- **Name:** First-Time Homebuyer Guide
- **Category:** Real Estate
- **Difficulty:** Beginner
- **Time to Implement:** 20 minutes

## Purpose

Guide first-time homebuyers through every step of the purchasing process with personalized roadmaps, insider tips, and program recommendations to avoid costly mistakes.

## Core Capabilities

1. **Personalized Roadmaps** - Tailored to financial situation
2. **Affordability Analysis** - How much house you can buy
3. **Program Identification** - First-time buyer assistance
4. **Step-by-Step Guidance** - Each phase explained
5. **Mistake Prevention** - Common pitfalls avoided

## Homebuying Phases

| Phase | Duration | Key Activities |
|-------|----------|----------------|
| Preparation | 3-12 mo | Credit, savings, research |
| Pre-Approval | 1-2 wks | Documents, shop lenders |
| House Hunting | Varies | Search, view, evaluate |
| Making Offers | 1-3 days | Price, terms, negotiate |
| Under Contract | 30-45 days | Inspection, appraisal, processing |
| Closing | 1 day | Sign, pay, get keys |

## Affordability Rules

### 28/36 Rule
- Housing ≤ 28% gross income
- Total debt ≤ 36% gross income

### Conservative Approach
- 25% of take-home pay
- Leave room for maintenance

## Loan Types

| Type | Down | Credit | Best For |
|------|------|--------|----------|
| Conventional | 3-20% | 620+ | Standard buyers |
| FHA | 3.5% | 580+ | Lower credit |
| VA | 0% | Varies | Veterans |
| USDA | 0% | 640+ | Rural areas |

## Assistance Programs

- Federal: FHA, VA, USDA
- State housing finance agencies
- Local down payment grants
- Employer assistance programs
- Mortgage Credit Certificates

## Common Mistakes

| Mistake | Why It Hurts |
|---------|--------------|
| Max out approval | Too house-poor |
| Forget closing costs | Short on cash |
| Big purchases before close | Kills approval |
| Skip inspection | Hidden problems |
| One lender quote | Miss better rates |
| Waive contingencies | No protection |

## Input Variables

| Variable | Description |
|----------|-------------|
| budget | Income or price range |
| savings | Down payment funds |
| location | Target area |
| timeline | When buying |

## Output Format

- Situation summary
- Affordability estimate
- Personalized roadmap by phase
- Relevant programs
- Tips for their situation
- Specific next steps

## Research Sources

- CFPB homebuying resources
- HUD first-time buyer programs
- State housing finance agencies
- NAR buyer resources

## Usage Instructions

1. Copy skill content to AI assistant
2. Share income, savings, location, timeline
3. Get personalized roadmap
4. Research recommended programs
5. Follow phase-by-phase guidance

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Homebuying phase knowledge (6 phases)
2. Affordability calculation methods
3. Loan type comparison data
4. First-time buyer program awareness
5. Common mistake identification
6. Personalized roadmap generation
