# Home Inspection Checklist Generator - Initialization Manifest

## Skill Identity

- **Name:** Home Inspection Checklist Generator
- **Category:** Real Estate
- **Difficulty:** Beginner
- **Time to Implement:** 10 minutes

## Purpose

Generate comprehensive, customized home inspection checklists based on property type, age, and climate. Help buyers know what to look for, what questions to ask, and which issues are deal-breakers.

## Core Capabilities

1. **Customized Checklists** - Tailored to property specifics
2. **Age-Based Issues** - Era-specific concerns and red flags
3. **Climate Adaptation** - Region-specific inspection points
4. **Priority Ranking** - Critical vs. negotiable issues
5. **Seller Questions** - What to ask and why

## Inspection Categories

| Category | Key Items |
|----------|-----------|
| Exterior | Foundation, roof, siding, drainage |
| Structure | Doors, windows, floors, walls |
| Moisture | Stains, odors, soft spots, sump pump |
| Plumbing | Pressure, drains, pipes, water heater |
| Electrical | Panel, outlets, wiring, GFCI |
| HVAC | Age, function, ducts, service history |

## Property Age Matrix

| Era | Major Concerns |
|-----|----------------|
| Pre-1950 | Knob-tube wiring, lead, asbestos, galvanized pipes |
| 1950-1970 | Aluminum wiring, cast iron, poor insulation |
| 1970-1990 | Polybutylene, FPE/Zinsco panels, EIFS |
| 1990-2010 | EIFS/composite, aging systems |
| 2010+ | Builder quality, settling, warranty |

## Climate Matrix

| Climate | Priority Checks |
|---------|-----------------|
| Hot/Humid | AC, mold, termites, hurricane prep |
| Cold | Heating, insulation, ice dams, pipes |
| Wet/Rainy | Roof, drainage, waterproofing |
| Dry/Desert | Cooling, UV damage, fire space |

## Input Variables

| Variable | Description |
|----------|-------------|
| property_type | Single-family, condo, townhouse, etc. |
| property_age | Year built or era |
| climate | Region or climate type |
| concerns | Specific red flags noticed |

## Output Format

For each property:
- Property overview summary
- Priority inspection items (critical → standard)
- Age-specific concerns
- Climate-specific concerns
- Questions for seller
- Red flag guide
- Printable checklist format

## Research Sources

- ASHI (American Society of Home Inspectors)
- NACHI (International Association of Certified Home Inspectors)
- HUD homebuying resources
- This Old House inspection guides

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide property details (type, age, location)
3. Mention any specific concerns
4. Receive customized checklist
5. Print and use during viewing

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Comprehensive home inspection category knowledge
2. Property age-era-specific issue awareness
3. Climate-based inspection variations
4. Deal-breaker vs. negotiation point classification
5. Ability to generate printable checklist formats
