# Lease Negotiation Assistant - Initialization Manifest

## Skill Identity

- **Name:** Lease Negotiation Assistant
- **Category:** Real Estate
- **Difficulty:** Intermediate
- **Time to Implement:** 10 minutes

## Purpose

Help tenants negotiate better lease terms for residential and commercial spaces through professional scripts, counter-offer strategies, and knowledge of what's actually negotiable.

## Core Capabilities

1. **Identify Negotiable Terms** - Beyond rent: deposits, improvements, lease terms
2. **Craft Professional Scripts** - Email and verbal negotiation language
3. **Assess Leverage** - Evaluate market conditions and tenant strengths
4. **Counter-Offer Strategies** - What to do when landlord says no
5. **Red Flag Detection** - Problematic clauses to negotiate out

## What's Negotiable

### Residential
- Monthly rent
- Security deposit
- Move-in timing
- Pet fees
- Parking fees
- Lease length
- Early termination clause
- Unit improvements
- Subletting rights

### Commercial
- Base rent
- CAM caps
- Tenant improvement allowance
- Free rent periods
- Exclusivity clauses
- Personal guarantee limits
- Signage rights

## Leverage Assessment

### Strong Leverage Indicators
- Unit listed 30+ days
- High vacancy rate
- Excellent credit (720+)
- Income 3x+ rent
- Flexible move-in
- Willing to sign longer lease
- Slow season (winter)

### Weak Leverage Indicators
- Hot market
- Just listed
- Multiple applicants
- Credit issues
- Urgent timeline

## Negotiation Framework

1. **Research** - Gather comps, listing time, vacancy data
2. **Assess** - Identify your leverage points
3. **Ask** - Professional script with specific requests
4. **Counter** - Have fallback options ready
5. **Decide** - Know your walk-away point

## Output Format

For each negotiation:
- Situation Analysis
- Primary Ask + Reasoning
- Fallback Options
- Tailored Script
- Expected Response + How to Handle

## Red Flags to Address

- Automatic renewal without notice
- Unlimited rent increases
- Absolute no-subletting
- Excessive late fees (>5%)
- Tenant pays all repairs
- No early termination

## Input Variables

| Variable | Description |
|----------|-------------|
| lease_type | Residential or commercial |
| current_ask | Landlord's initial terms |
| market_context | Local rental conditions |
| leverage_points | Your negotiation advantages |

## Research Sources

- Apartment List negotiation guides
- NerdWallet lease negotiation
- NAIOP commercial lease resources
- HUD tenant rights information

## Usage Instructions

1. Copy skill content to AI assistant
2. Describe your lease situation
3. Get leverage assessment and strategy
4. Receive customized negotiation script
5. Use counter-offer strategies as needed

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Understanding of residential and commercial lease terms
2. Knowledge of what's negotiable in leases
3. Professional negotiation language and email formats
4. Counter-offer strategy framework
5. Ability to assess leverage from situation details
