# Mortgage Comparison Advisor - Initialization Manifest

## Skill Identity

- **Name:** Mortgage Comparison Advisor
- **Category:** Real Estate
- **Difficulty:** Intermediate
- **Time to Implement:** 15 minutes

## Purpose

Compare mortgage offers with expert analysis of APR, points, fees, and true costs to find the best loan for your specific situation and timeline.

## Core Capabilities

1. **True Cost Calculation** - Total costs at various time horizons
2. **APR Analysis** - Rate vs. APR differences explained
3. **Points Breakeven** - When buying points pays off
4. **Loan Type Comparison** - 30/15-year, fixed vs. ARM
5. **Timeline Optimization** - Best choice based on how long you'll stay

## Key Formulas

### Monthly Payment
```
M = P × [r(1+r)^n] / [(1+r)^n – 1]
```

### Points Breakeven
```
Breakeven months = Points paid ÷ Monthly savings
```

### Total Cost at Year N
```
(Monthly Payment × N × 12) + Closing Costs
```

## Comparison Metrics

| Metric | What It Shows |
|--------|---------------|
| Interest Rate | Base borrowing cost |
| APR | Rate + fees over loan life |
| Points | Upfront cost for lower rate |
| Closing Costs | All fees at closing |
| Monthly P&I | What you pay monthly |
| Year 5 Cost | Total if you move/refi in 5 years |
| Breakeven | When points pay for themselves |

## Loan Types

| Type | Best For |
|------|----------|
| 30-Year Fixed | Lower payments, flexibility |
| 15-Year Fixed | Fastest equity, least interest |
| 5/1 ARM | Moving/refinancing in <5 years |
| 7/1 ARM | Moving/refinancing in <7 years |

## Red Flags

- Prepayment penalties
- Balloon payments
- Excessive junk fees
- Required products
- Large APR/rate gap

## Input Variables

| Variable | Description |
|----------|-------------|
| loan_amount | Amount borrowing |
| loan_term | Term in years |
| offers | Rate, points, fees for each lender |
| plans | How long staying in home |

## Output Format

For each comparison:
- Summary table with all metrics
- Timeline analysis (Year 5, 7, 10, 30)
- Points breakeven calculation
- Key insights and red flags
- Clear recommendation with reasoning

## Research Sources

- CFPB mortgage guidance
- Bankrate calculators
- NerdWallet comparison tools
- Investopedia APR explanations

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide loan amount and offers
3. Specify your timeline/plans
4. Get comparison analysis
5. Use recommendation to negotiate

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Mortgage payment calculation formulas
2. APR vs rate understanding
3. Points breakeven analysis
4. Loan type comparison knowledge
5. Ability to build comparison tables
6. Timeline-based recommendation logic
