# Neighborhood Research Analyst - Initialization Manifest

## Skill Identity

- **Name:** Neighborhood Research Analyst
- **Category:** Real Estate
- **Difficulty:** Beginner
- **Time to Implement:** 15 minutes

## Purpose

Research neighborhoods comprehensively before buying or renting, analyzing safety, schools, walkability, demographics, and development to make informed location decisions.

## Core Capabilities

1. **Multi-Factor Analysis** - Safety, schools, lifestyle, market
2. **Lifestyle Matching** - Neighborhoods to needs alignment
3. **Comparison Framework** - Side-by-side scorecards
4. **Red Flag Detection** - Hidden concerns identification
5. **Resource Guidance** - Where to find data

## Research Categories

| Category | Key Metrics |
|----------|-------------|
| Safety | Crime rates, trends, types |
| Schools | GreatSchools ratings, boundaries |
| Walkability | Walk/Transit/Bike Scores |
| Demographics | Age, income, owner/renter |
| Amenities | Restaurants, parks, healthcare |
| Housing | Prices, trends, inventory |
| Future | Development, zoning, risks |

## Lifestyle Profiles

| Profile | Priorities |
|---------|------------|
| Young Professional | Nightlife, commute, social scene |
| Family | Schools, safety, outdoor space |
| Remote Worker | Office space, internet, quiet |
| Retiree | Healthcare, maintenance, safety |

## Red Flags

- Upward crime trends
- Schools below 5 rating
- Rapid gentrification
- Major planned construction
- Environmental risks (flood zone)
- High rental turnover

## Resource List

| Type | Sources |
|------|---------|
| Safety | CrimeMapping, NeighborhoodScout, SpotCrime |
| Schools | GreatSchools, Niche, SchoolDigger |
| Walkability | WalkScore, Google Maps |
| Demographics | City-Data, Census, BestPlaces |
| Housing | Zillow, Redfin, local MLS |
| Development | City planning, local news |

## Visit Checklist

- Walk the streets at different times
- Visit local coffee shop
- Check out nearest park
- Drive commute at rush hour
- Talk to residents
- Notice home maintenance
- Check phone signal

## Input Variables

| Variable | Description |
|----------|-------------|
| neighborhood | Area being researched |
| priorities | Top concerns (safety, schools, etc.) |
| lifestyle | User profile |
| budget | Price range context |

## Output Format

- Quick stats summary
- Category-by-category analysis
- Best for / Not ideal for
- Comparison scorecard
- Research next steps
- Relevant resources

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide neighborhood name
3. Share priorities and lifestyle
4. Receive comprehensive analysis
5. Follow up with visit checklist

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Neighborhood research categories framework
2. Lifestyle-to-location matching logic
3. Red flag identification criteria
4. Resource recommendation knowledge
5. Comparison scorecard generation
