---
name: property-investment-analyzer
version: 1.0.0
description: Analyze rental properties with professional-grade investment metrics
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive real estate investment analysis capabilities including cap rate, cash-on-cash return, NOI calculations, and due diligence frameworks.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with investment analysis frameworks

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r property-investment-analyzer/ ~/.claude/skills/property-investment-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{property_type}}` | `single-family rental` | Target property type |
| `{{investment_strategy}}` | `cash flow focused` | Investment approach |

## Key Metrics Reference

Quick reference for investment analysis:

| Metric | Formula | Good Target |
|--------|---------|-------------|
| Cap Rate | NOI / Price | 6-8%+ |
| Cash-on-Cash | Cash Flow / Cash Invested | 8%+ |
| 1% Rule | Monthly Rent / Price | 1%+ |
| DSCR | NOI / Debt Service | 1.25+ |
| 50% Rule | Expenses / Gross Rent | ≤50% |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
