# Property Listing Copywriter - Initialization Manifest

## Skill Identity

- **Name:** Property Listing Copywriter
- **Category:** Real Estate
- **Difficulty:** Beginner
- **Time to Implement:** 10 minutes

## Purpose

Transform basic property details into compelling listings that attract buyers and generate showings using proven real estate copywriting formulas and emotional triggers.

## Core Capabilities

1. **Feature-to-Benefit Transformation** - Convert specs into lifestyle benefits
2. **MLS Optimization** - Headlines and descriptions that perform
3. **Buyer Targeting** - Messaging for specific demographics
4. **Fair Housing Compliance** - Avoid violations
5. **Multi-Format Output** - MLS, extended, social media

## Copywriting Formulas

### Headline Formula
```
[Power Word] + [Key Feature] + [Lifestyle Benefit] + [Hook]
```

### Opening Line Types
- WOW factor lead
- Emotional hook
- Target buyer call-out
- Scarcity/urgency

### Body Structure
1. Hook (lifestyle/emotion)
2. Living spaces
3. Private spaces
4. Bonus features
5. Location
6. Call to action

## Word Banks

| Category | Examples |
|----------|----------|
| Luxury | Exquisite, Pristine, Custom, Gourmet |
| Lifestyle | Sun-drenched, Open-concept, Tranquil |
| Condition | Turnkey, Move-in ready, Renovated |
| Action | Imagine, Discover, Welcome home |

## Avoid List

- Vague: nice, good, great
- Negative signals: cozy, charming, TLC, motivated
- Fair Housing violations

## Property Type Adjustments

| Type | Focus Areas |
|------|-------------|
| Single-Family | Space, yard, schools |
| Condo | Convenience, amenities, views |
| Investment | Cap rate, rents, upside |
| Luxury | Exclusivity, custom, lifestyle |

## Buyer Demographics

| Buyer | Emphasize |
|-------|-----------|
| First-Time | Move-in ready, starter, affordable |
| Families | Schools, backyard, bedrooms |
| Empty Nesters | Low maintenance, quality |
| Remote Workers | Office, internet, quiet |

## Input Variables

| Variable | Description |
|----------|-------------|
| property_details | Beds, baths, sqft, features |
| target_buyer | Ideal buyer profile |
| unique_features | Standout elements |
| neighborhood | Location highlights |

## Output Format

- MLS headline (80 chars)
- MLS description (500-1000 chars)
- Extended marketing narrative
- Social media caption
- Bullet point highlights

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide property details and features
3. Specify target buyer
4. Highlight location benefits
5. Receive multi-format listings

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Feature-to-benefit transformation skills
2. Real estate power word vocabulary
3. MLS format and character limit awareness
4. Fair Housing compliance knowledge
5. Buyer demographic messaging strategies
