# Rental Property ROI Calculator - Initialization Manifest

## Skill Identity

- **Name:** Rental Property ROI Calculator
- **Category:** Real Estate
- **Difficulty:** Intermediate
- **Time to Implement:** 15 minutes

## Purpose

Calculate accurate rental property returns with comprehensive analysis of cash-on-cash, cap rate, cash flow, and total ROI including leverage, expenses, and appreciation scenarios.

## Core Capabilities

1. **Multi-Metric Analysis** - Cap rate, CoC, total ROI
2. **Expense Modeling** - All operating and capital expenses
3. **Scenario Testing** - Occupancy, rent growth, appreciation
4. **Leverage Analysis** - Impact of financing on returns
5. **Tax Benefit Estimation** - Depreciation shield calculations

## Key Formulas

### Cap Rate
```
NOI ÷ Property Value × 100
Target: 6-10%
```

### Cash-on-Cash
```
Annual Cash Flow ÷ Total Cash Invested × 100
Target: 8-12%
```

### Total ROI
```
(Cash Flow + Appreciation + Equity Paydown) ÷ Investment × 100
```

### NOI
```
Gross Rent - Vacancy - Operating Expenses
(Excludes debt service)
```

### Monthly Mortgage
```
P × [r(1+r)^n] / [(1+r)^n – 1]
```

## Expense Categories

| Expense | Typical % |
|---------|-----------|
| Property Taxes | 1-2% of value |
| Insurance | 0.5-1% of value |
| Management | 8-10% of rent |
| Maintenance | 1% of value |
| CapEx Reserve | 5-10% of rent |
| Vacancy | 5-10% of rent |

## Quick Screening Rules

| Rule | Formula | Target |
|------|---------|--------|
| 1% Rule | Rent ÷ Price | ≥1% |
| 50% Rule | Expenses ≈ 50% of rent | Estimate |
| DSCR | NOI ÷ Debt Service | ≥1.25 |

## Minimum Targets

- Cap Rate: 6%+
- Cash-on-Cash: 8%+
- Monthly Cash Flow: $100/unit
- DSCR: 1.25+

## Input Variables

| Variable | Description |
|----------|-------------|
| purchase_price | Property price |
| monthly_rent | Expected rent |
| down_payment | Down payment amount/% |
| expenses | Known expenses |

## Output Format

- Property summary
- Income & expense breakdown
- Key metrics with targets
- Occupancy sensitivity
- 5-year projection
- Total ROI breakdown
- Verdict and recommendations

## Research Sources

- BiggerPockets rental calculator
- Investopedia cash-on-cash
- Forbes cap rate guide
- Roofstock ROI methodology

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide property details and financials
3. Get comprehensive ROI analysis
4. Review scenario projections
5. Use verdict for decision-making

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Real estate investment metric formulas
2. Complete expense category knowledge
3. Scenario modeling capability
4. Mortgage calculation ability
5. Tax depreciation understanding
6. Comparison benchmark data
