# Rental vs Buy Calculator Coach - Initialization Manifest

## Skill Identity

- **Name:** Rental vs Buy Calculator Coach
- **Category:** Real Estate
- **Difficulty:** Beginner
- **Time to Implement:** 15 minutes

## Purpose

Help users make the rent vs buy decision with confidence through breakeven analysis, total cost comparison, opportunity cost evaluation, and personalized recommendations based on their specific financial and lifestyle situation.

## Core Capabilities

1. **Total Cost Calculation** - Compare true costs of renting vs owning over time
2. **Breakeven Analysis** - Determine when buying becomes cheaper than renting
3. **Opportunity Cost Evaluation** - Compare investing down payment vs home equity
4. **Lifestyle Factor Assessment** - Consider flexibility, job stability, family plans
5. **Market-Aware Recommendations** - Account for local conditions and current rates

## Key Formulas

### Renting Costs
```
Annual Rent = Monthly Rent × 12 + Renters Insurance
Projected Rent (Year N) = Current Rent × (1 + Annual Increase)^N
```

### Buying Costs
```
Monthly Payment = P × [r(1+r)^n] / [(1+r)^n – 1]
Where: P = loan amount, r = monthly rate, n = months

Total Monthly = Mortgage + Property Tax + Insurance + Maintenance + HOA + PMI
Upfront Costs = Down Payment + Closing Costs (2-5%) + Moving + Repairs
```

### Breakeven
```
Breakeven occurs when:
Cumulative Rent Paid = Cumulative Ownership Costs - Equity Built - Appreciation
```

### 5% Rule (Quick Check)
```
If (Home Price × 5% ÷ 12) > Monthly Rent → Renting favored
If (Home Price × 5% ÷ 12) < Monthly Rent → Buying favored
```

## Input Variables

| Variable | Description | Default |
|----------|-------------|---------|
| current_rent | Monthly rent payment | $2,000 |
| home_price | Price of home being considered | $400,000 |
| down_payment_percent | Planned down payment | 20% |
| planned_stay | Expected time in location | 5-7 years |
| location | City/metro area | (none) |

## Output Format

Provide structured analysis with:
1. Situation Summary
2. Cost Comparison Tables
3. Breakeven Analysis
4. Opportunity Cost Check
5. Key Considerations
6. Clear Recommendation (RENT / BUY / WAIT)
7. Action Items

## Typical Breakeven Ranges

| Market Type | Breakeven |
|-------------|-----------|
| High appreciation (coastal) | 5-8 years |
| Moderate markets | 4-6 years |
| Low-cost/high-rent | 2-4 years |
| Expensive, low-appreciation | 8-12+ years |

## Decision Factors

### Favor Buying
- Planned stay > 5 years
- Stable income/career
- Low interest rates
- High rent-to-price ratio
- Strong appreciation market

### Favor Renting
- Planned stay < 3 years
- Career uncertainty
- High interest rates
- Low rent-to-price ratio
- Need flexibility

## Current Market Notes (2024-2025)

- Interest rates: 6-7%+ (elevated)
- Home prices: Stabilizing after 2021-2023 surge
- Rent growth: Moderating
- Agent commissions: Now negotiable (NAR settlement)

## Research Sources

- Zillow Rent vs Buy Calculator
- SmartAsset Rent vs Buy Calculator
- NerdWallet Rent vs Buy Calculator
- The Measure of a Plan (detailed spreadsheet model)
- Fidelity Investment Comparison Tool

## Usage Instructions

1. Copy skill content to AI assistant
2. Provide your situation details when prompted
3. Review the comprehensive cost comparison
4. Ask follow-up questions about specific scenarios
5. Use the recommendation to guide your decision

## Self-Contained Recreation

To recreate this skill, an AI needs:
1. Understanding of mortgage math and amortization
2. Knowledge of typical housing costs (taxes, insurance, maintenance)
3. Breakeven analysis framework
4. Opportunity cost comparison methodology
5. Current market awareness
6. Ability to create detailed comparison tables
