---
name: couples-finance-meeting-agendas
version: 1.0.0
---

# Initialization

Structured meeting frameworks for couples merging finances. Includes 4 agenda types: Discovery Meeting (first financial conversation), Account Setup Meeting (implementing decisions), Quarterly Review (ongoing check-ins), and Annual Planning (comprehensive yearly review).

## Structure

- `SKILL.md` - Main skill prompt with all meeting agenda templates

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r couples-finance-meeting-agendas/ ~/.claude/skills/couples-finance-meeting-agendas/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT's "Custom Instructions" or create a new GPT with the content as system instructions

### Gemini
1. Open `SKILL.md`
2. Copy the full prompt content
3. Start a new Gemini conversation and paste as initial context

### Copilot
1. Open `SKILL.md`
2. Copy the prompt content
3. Paste into Copilot chat to establish the assistant persona

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{meeting_type}}` | `discovery` | Which agenda to generate (discovery, setup, quarterly, annual) |
| `{{combined_monthly_income}}` | `$8,000` | Total household monthly income after taxes |
| `{{relationship_stage}}` | `newly_merged` | Newly merged, established, or re-aligning after major change |
| `{{account_structure_preference}}` | `yours_mine_ours` | Yours-mine-ours, fully merged, or separate with proportional split |
| `{{meeting_duration}}` | `90` | Target meeting length in minutes |
| `{{financial_complexity}}` | `moderate` | Simple, moderate, or complex financial situation |

## Meeting Types Overview

### Discovery Meeting (90-120 min)
First major financial conversation. Covers:
- Values & vision discussion
- Full financial inventory (income, assets, debts)
- Account structure decision (yours/mine/ours, merged, or separate)
- Preliminary budget creation
- Action items and next steps

### Account Setup Meeting (60 min)
Execute Discovery Meeting decisions. Covers:
- Opening joint/individual accounts
- Beneficiary updates on all accounts
- Direct deposit and automatic transfer setup
- Debt payoff strategy
- Budget tool configuration

### Quarterly Review Meeting (45-60 min)
Ongoing check-in every 3 months. Covers:
- Spending vs. budget analysis
- Goal progress tracking
- Income and life updates
- Debt status review
- Relationship check-in

### Annual Planning Meeting (2-3 hours)
Comprehensive yearly review. Covers:
- Net worth assessment
- Tax planning and income review
- Annual spending deep-dive
- Retirement and long-term planning
- Insurance and estate review
- Strategic adjustments for next year
- Financial calendar setup

## Example Usage

```
My partner and I just got engaged and want to start planning our
finances together before we get married next year. We've never
really talked about money in detail. I make $75,000 and they make
$55,000. We both have some student loan debt. Can you help us
create a Discovery Meeting agenda?
```

## Related Skills

- **Couples Financial Alignment Tool** - Identify money personalities
- **Couples Financial Conflict Solver** - Resolve money disagreements
- **Budget Planner** - Create detailed household budgets
- **Financial Goal Tracker** - Track shared financial milestones
- **Debt Elimination Sequencer** - Prioritize debt payoff

---
Downloaded from [Find Skill.ai](https://findskill.ai)
