---
name: date-night-roulette
version: 1.0.0
---

# Date Night Roulette - Initialization

An AI-powered decision assistant that eliminates "what do you want to do?" paralysis by randomly but intelligently picking date activities from curated options, filtered by budget, mood, location, and time.

## Package Structure

```
date-night-roulette/
├── SKILL.md      # Main skill prompt (500+ lines)
└── INIT.md       # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code / Claude Desktop
```bash
# Copy to skills directory
cp -r date-night-roulette/ ~/.claude/skills/date-night-roulette/
```

Then reference with: `Read ~/.claude/skills/date-night-roulette/SKILL.md`

### ChatGPT / GPT-4
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or Custom Instructions
4. Start conversation with "Date night roulette!"

### Gemini / Copilot
1. Open `SKILL.md`
2. Copy the main content
3. Paste as the opening context for your conversation
4. Provide your constraints when prompted

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `budget_max` | $50 | Maximum spend for the date |
| `activity_duration` | 2-3 hours | How long the date should last |
| `location_preference` | flexible | indoor_only, outdoor_only, or flexible |
| `mood` | balanced | chill, adventurous, romantic, or balanced |
| `distance_radius` | 10 miles | How far you're willing to travel |

## Quick Start Examples

**Tonight's Quick Spin:**
```
Date Night Roulette: Spin for tonight! Under $30, staying local, something chill.
```

**Weekend Adventure:**
```
Date Night Roulette: Plan a Saturday adventure date. Budget up to $100, we want something active and memorable.
```

**Compromise Mode:**
```
Date Night Roulette: Partner wants low-key cozy night, I want to go out. Find us middle ground under $50.
```

**Free Date Challenge:**
```
Date Night Roulette: Give us your best free date ideas. We have 3 hours on Sunday afternoon.
```

**Spontaneity Mode:**
```
Date Night Roulette: Surprise us! We usually do dinner and movies. Show us something different.
```

## Core Features

- **Quick Spin**: Instant date idea with budget, duration, and prep info
- **Backup Options**: Always provides 2-3 alternatives
- **Veto System**: 3 vetoes per session with adaptive filtering
- **Compromise Mode**: Merges two different partner preferences
- **Spontaneity Mode**: Prioritizes novelty over favorites
- **Category Balance**: Prevents repeating the same type of dates
- **Seasonal Awareness**: Adjusts for weather and time of year

## Supported Categories

- Food & Drink (restaurants, cooking, picnics)
- At-Home Cozy (movies, games, spa night)
- Outdoor Adventure (hiking, water sports, mini golf)
- Cultural & Learning (museums, concerts, classes)
- Active & Sports (bowling, escape rooms, skating)
- Unique & Seasonal (festivals, holiday events, farmers markets)

## Tips for Best Results

1. **Be specific about constraints** - Budget, time, and vibe help narrow options
2. **Use veto feedback** - Tell the AI why you're vetoing to get better next suggestions
3. **Try Spontaneity Mode** - If dates feel repetitive, say "surprise me"
4. **Rate your dates** - Report back with 1-5 ratings for better future suggestions
5. **Create custom lists** - Ask to save themed lists like "Rainy Day Dates"

---
Downloaded from [Find Skill.ai](https://findskill.ai)
