---
name: difficult-conversation-opener
version: 1.0.0
---

# Initialization

Transform how you start difficult relationship conversations using evidence-based communication frameworks from Gottman, NVC, EFT, and Imago Dialogue. This skill helps you open sensitive discussions in ways that keep your partner receptive and collaborative rather than defensive.

## Structure

- `SKILL.md` - Main skill prompt with complete conversation preparation framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r difficult-conversation-opener/ ~/.claude/skills/difficult-conversation-opener/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Start a new conversation describing the discussion you need to have

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `conversation_topic` | `feeling disconnected` | The issue you need to discuss |
| `partner_name` | `my partner` | Your partner's name or preferred reference |
| `relationship_type` | `romantic partner` | Type of relationship (romantic, family, friendship) |
| `urgency_level` | `moderate` | How time-sensitive the conversation is |
| `emotional_state` | `calm but concerned` | Your current emotional state |
| `preferred_framework` | `adaptive` | Communication framework preference (gottman, nvc, imago, eft, adaptive) |

## Example Usage

**Scenario**: You feel emotionally neglected and want to discuss intimacy without starting a fight.

**Prompt**:
```
I need to talk to my partner about feeling emotionally neglected. We've both been
busy with work, and I feel like we haven't really connected in weeks. I don't want
to start a fight or make them feel attacked - I just want to feel closer again.
Help me figure out how to start this conversation.
```

**What you'll receive**:
- A customized "softened start-up" opening script
- Backup phrases for defensive, shut-down, or angry responses
- Timing and setting recommendations
- Self-regulation techniques for pre-conversation calm

## Key Frameworks Included

### Gottman's Softened Start-Up
Research shows the first 3 minutes predict 96% of conversation outcomes. This framework teaches gentle, non-blaming openings.

### Nonviolent Communication (NVC)
Four-component structure: Observation → Feeling → Need → Request

### Imago Dialogue
Structured listening: Mirroring → Validation → Empathy

### Emotionally Focused Therapy (EFT)
Reframe from "you vs. me" to "us vs. the pattern"

## When to Use This Skill

- Starting conversations about unmet emotional needs
- Addressing relationship concerns before they escalate
- Opening discussions about difficult topics (finances, family, values)
- De-escalating existing tensions
- Expressing vulnerability while inviting collaboration

---
Downloaded from [Find Skill.ai](https://findskill.ai)
