---
name: friendship-fadeout-scripts
version: 1.0.0
description: End friendships you've outgrown with honesty and compassion using situation-specific scripts
author: Find Skill.ai
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
---

# Initialization: Friendship Fadeout Scripts

Generate customized scripts for ending friendships without ghosting. Provides situation-specific communication templates for in-person, text, phone, and letter formats with response handling strategies.

## Structure

```
friendship-fadeout-scripts/
├── SKILL.md          # Main skill prompt (800+ lines)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Quick Start

### For Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r friendship-fadeout-scripts/ ~/.claude/skills/friendship-fadeout-scripts/
```

### For ChatGPT / Gemini / Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin your conversation

## Variables

| Variable | Default | Options | Description |
|----------|---------|---------|-------------|
| `friendship_type` | `medium-term` | long-term, medium-term, recent, situational | Duration and depth of friendship |
| `ending_reason` | `grown-apart` | grown-apart, value-mismatch, draining, boundary-violation, toxic | Primary reason for ending |
| `communication_method` | `text` | in-person, phone, text, letter | How you want to communicate |
| `mutual_friends` | `few` | none, few, many | Shared social circle complexity |
| `desired_finality` | `complete-cut` | complete-cut, cordial-distance, door-open | Future contact preference |

## Usage Examples

### Example 1: Long-term friendship grown apart
```
I need to end a 12-year friendship. We've just grown apart naturally - no drama,
we're just different people now. We have several mutual friends. I want to do
this in person but need help with what to say.
```

### Example 2: Draining friend via text
```
Help me write a text to end a friendship with someone who's become emotionally
draining. Everything is always about her problems. We've been friends 4 years.
I don't want future contact.
```

### Example 3: Boundary violation
```
My friend keeps sharing my personal information with others after I've asked
her to stop multiple times. I need to end this friendship clearly. We work
in the same building so I'll see her around.
```

### Example 4: Values mismatch
```
My college friend and I have completely different values now - politically,
socially, everything. Every conversation becomes an argument. No mutual friends.
I want to do this kindly over email.
```

## Key Features

- **4-Part Script Framework**: Acknowledgment, Decision, Brief Why, Boundary
- **5 Situation Templates**: Growing apart, values mismatch, draining, boundary violation, toxic
- **Communication Method Guidance**: In-person, phone, text, letter recommendations
- **Response Handling Scripts**: For pushback, anger, negotiation attempts
- **Special Situations**: Mutual friends, social circles, family connections
- **Self-Care Guidance**: Post-conversation emotional processing
- **When to Ghost**: Justified scenarios for no-contact approach

## What This Skill Provides

1. **Assessment Questions** - Gathers context about your specific situation
2. **Communication Method Recommendation** - Based on friendship type and circumstances
3. **Customized Scripts** - Ready-to-use or adapt for your situation
4. **Response Preparation** - How to handle likely reactions
5. **Mutual Friend Guidance** - What to say to shared connections
6. **Self-Care Plan** - Emotional processing after the conversation

## Ethical Guidelines

This skill helps users:
- End friendships with honesty rather than ghosting
- Communicate boundaries clearly and compassionately
- Avoid blame while being direct
- Handle responses without being manipulated into reversing decisions

This skill does NOT support:
- Cruel or vindictive messaging
- Detailed lists of the other person's faults
- Manipulative or gaslighting language
- Leaving doors falsely open

## Tips for Best Results

1. **Be specific about your situation** - Include friendship length, reason, communication preference
2. **Mention mutual friend dynamics** - This affects script recommendations
3. **State your desired outcome clearly** - Complete cut vs. cordial distance
4. **Ask for response preparation** - Know how to handle pushback before it happens
5. **Request self-care guidance** - Don't skip the emotional processing part

---
Downloaded from [Find Skill.ai](https://findskill.ai)
