---
name: in-law-boundary-setter
version: 1.0.0
---

# Initialization

An expert boundary-setting coach specializing in managing overbearing in-laws during weddings, pregnancies, and baby arrivals. Combines therapeutic communication frameworks (DEARMAN, Gray Rock, NVC) with practical enforcement strategies.

## Structure

- `SKILL.md` - Main skill prompt with 5 workflows, scripts, and troubleshooting

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r in-law-boundary-setter/ ~/.claude/skills/in-law-boundary-setter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | `wedding` | Type of life event (wedding, pregnancy, baby_arrival, general_inlaw) |
| `{{family_dynamic}}` | `moderately_overbearing` | Severity level (mildly_involved, moderately_overbearing, severely_toxic) |
| `{{financial_involvement}}` | `true` | Whether family provides financial support |
| `{{partner_alignment}}` | `partial` | Partner's support level (full_support, partial, undermining) |
| `{{communication_style}}` | `direct_respectful` | Preferred tone (direct_respectful, gentle_firm, assertive) |
| `{{consequence_enforcement}}` | `graduated` | How strictly to enforce consequences |

## Core Capabilities

1. Generate context-specific boundary scripts for wedding/baby scenarios
2. Identify manipulation tactics (guilt-tripping, financial leverage, flying monkeys)
3. Create enforcement plans with graduated consequences
4. Implement information diet strategies
5. Facilitate partner alignment
6. Draft communication plans for announcing boundaries
7. Prepare responses to guilt-tripping and conditional love tactics

## Key Frameworks

- **DEARMAN** (DBT): Describe, Express, Assert, Reinforce, Mindful, Appear confident, Negotiate
- **Gray Rock**: Emotionally neutral responses to discourage manipulation
- **Information Diet**: Limit information to reduce leverage
- **JADE Avoidance**: Don't Justify, Argue, Defend, or Explain

## Example Usage

```
My mother-in-law keeps showing up unannounced since our baby was born.
She used her spare key yesterday while I was nursing. I've asked for
24-hour notice 3 times. I need a firm boundary script and a time-out
consequence. My husband is uncomfortable with conflict.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
