---
name: jealousy-reality-check
version: 1.0.0
---

# Jealousy Reality Check - Initialization

A diagnostic AI skill that helps users distinguish between valid relationship red flags and internal insecurity/anxiety. Uses psychology-backed frameworks including CBT, attachment theory, Gottman research, and Nonviolent Communication.

## What This Skill Does

- Separates observable facts from fear-based interpretations
- Detects cognitive distortions (mind reading, catastrophizing, etc.)
- Scans for legitimate red flags and gaslighting patterns
- Assesses internal vulnerability factors (HALT states, attachment triggers)
- Provides customized NVC communication scripts
- Evaluates relationship trust baseline
- Differentiates retroactive jealousy from present concerns

## Structure

```
jealousy-reality-check/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r jealousy-reality-check/ ~/.claude/skills/jealousy-reality-check/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Alternatively, paste directly into a new conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `trigger_event` | `partner_behavior` | The specific action that caused the jealousy (e.g., late text, hidden phone) |
| `attachment_style` | `unknown` | User's attachment style: anxious, avoidant, secure, or unknown |
| `relationship_duration` | `unspecified` | How long the relationship has lasted |
| `trust_history` | `false` | Whether there has been confirmed infidelity in the past |
| `emotional_intensity` | `5` | Current emotional state on a 1-10 scale |
| `partner_reaction` | `unknown` | How partner responded: defensive, reassuring, dismissive, or unknown |

## Example Usage

```
"I need a Reality Check. My boyfriend got a text at 11 PM and turned
his phone screen down immediately. I asked who it was, and he said
'just work' but didn't show me. I'm freaking out thinking he's cheating.
Am I being paranoid or is this shady? We've been together 2 years,
no history of cheating."
```

```
"Help me diagnose this feeling. I found an old photo of my girlfriend
with her ex on Facebook from 5 years ago. She looks so happy. I feel
sick and want to ask her if she loved him more than me. I know this
is irrational but I can't stop thinking about it. Is this a red flag
or just me?"
```

```
"I told my partner I felt insecure when he went to lunch with his
female coworker without telling me. He exploded and told me I'm
'crazy' and 'trying to control his life' and that I'm 'ruining the
relationship.' Now I'm apologizing to him. Did I do something wrong?"
```

## Key Frameworks Used

1. **Facts vs. Story Audit** - Separating observable behavior from interpretation
2. **Cognitive Distortion Catalog** - Identifying 8 common thinking errors
3. **Red Flag Scanner** - Checklist of legitimate warning signs
4. **DARVO Detection** - Recognizing gaslighting response patterns
5. **HALT Check** - Assessing hunger, anger, loneliness, tiredness
6. **Attachment Trigger Analysis** - Understanding anxious/avoidant patterns
7. **Retroactive Jealousy Filter** - Distinguishing past-focused obsession
8. **NVC Communication Scripts** - Structured approach to difficult conversations
9. **Gottman Trust Metrics** - Sliding door moments and Four Horsemen
10. **Reality Score Framework** - Final validity assessment (1-10)

## Safety Notes

This skill includes:
- Crisis resource information (hotlines)
- Clear disclaimers about not replacing therapy
- Escalation guidance for dangerous situations
- Ethical boundaries on what the skill can/cannot do

## Related Skills

- Love Bombing Detector - Identify manipulation in early dating
- Cognitive Reframing Guide - CBT techniques for thought patterns
- Emotional Regulation Coach - DBT strategies for intense emotions
- Assertive Communication Coach - Boundary-setting scripts
- Conflict Resolution Role-Player - Practice difficult conversations

---

Downloaded from [Find Skill.ai](https://findskill.ai)
