---
name: partner-mental-load-auditor
version: 1.0.0
---

# Partner Mental Load Auditor - Initialization

An AI skill for identifying and redistributing invisible household cognitive labor between partners. Uses the CPE (Conception-Planning-Execution) framework from Eve Rodsky's Fair Play methodology combined with Gottman Institute relationship principles.

## What This Skill Does

- **CPE Analysis:** Breaks down household tasks to reveal who owns the full lifecycle (Conception → Planning → Execution) versus just the final step
- **Invisible Task Discovery:** Prompts users to identify easy-to-miss cognitive labor (knowing the kid's shoe size, remembering birthdays, monitoring supplies)
- **Standard of Care Negotiation:** Facilitates agreements on how tasks should be done to prevent gatekeeping or weaponized incompetence
- **Task Ownership Transfer:** Provides structured handover protocols for completely transferring responsibility
- **Conflict-Neutral Scripts:** Generates conversation starters and responses for sensitive labor discussions

## Package Structure

```
partner-mental-load-auditor/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md file contains all instructions.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r partner-mental-load-auditor/ ~/.claude/skills/partner-mental-load-auditor/
```

Then use with: "Use the partner-mental-load-auditor skill to help me audit household responsibilities"

### ChatGPT / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation or custom GPT instructions
4. Start your conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audit_depth}}` | `basic` | Granularity level: `basic` (overview), `deep` (detailed sub-tasks), `category_specific` (one domain deep-dive) |
| `{{household_type}}` | `couple_with_kids` | Adjusts task suggestions: `roommates`, `couple`, `couple_with_kids`, `single_parent` |
| `{{tone_style}}` | `neutral` | Communication persona: `neutral` (objective), `empathetic` (gentle), `direct` (no-nonsense) |
| `{{primary_pain_point}}` | `burnout` | Tailors starting point: `burnout`, `resentment`, `nagging`, `forgetfulness` |
| `{{check_in_frequency}}` | `weekly` | Suggests workflows based on discussion cadence: `daily`, `weekly`, `monthly` |

## Example Prompts

### Initial Reality Check

```
My partner says they "help around the house" all the time, but I'm still
exhausted. I want to understand if I'm carrying all the "project manager"
work - the remembering, planning, and anticipating. Help me audit who
handles the Conception and Planning versus just the Execution.
```

### Defining Standards

```
We keep fighting about laundry. I say it's not done; they say it is.
Help us draft a "Minimum Standard of Care" agreement for laundry so we
can agree on what "done" actually means. Include sorting, washing,
folding, and putting away.
```

### Task Transfer

```
I want to fully hand over "Weekly Meal Planning" to my partner. Currently
I do the grocery list, check the pantry, and find recipes. Generate a
checklist of information I need to give them so they can take Total
Ownership of this task without ever asking me questions about it.
```

### Resistance Response

```
When I try to talk about mental load, my partner says "just tell me what
to do and I'll do it." Help me explain why that response IS the problem,
using non-confrontational language.
```

## Key Concepts Reference

- **CPE (Conception-Planning-Execution):** The three phases of every task
- **Mental Load:** Invisible cognitive work of anticipating, planning, monitoring
- **Manager vs. Helper:** Imbalanced dynamic where one plans, one executes when asked
- **Gatekeeping:** Controlling/criticizing how tasks are done, undermining ownership
- **Weaponized Incompetence:** Doing tasks poorly to avoid future responsibility
- **Minimum Standard of Care (MSC):** Agreed definition of "done" for each task
- **Total Ownership:** Full CPE responsibility with zero reminders needed
- **Unicorn Space:** Personal time reclaimed when mental load is balanced

## Recommended Workflow

1. **Start Small:** Begin with one task category, not entire household
2. **Audit First:** Complete CPE tagging before proposing changes
3. **Define Standards:** Agree on MSC before any handover
4. **Formal Handover:** Make ownership transfer explicit
5. **Weekly Check-ins:** Use Kitchen Table Meeting template
6. **Track Progress:** Monthly quantitative and qualitative review

## Limitations

- Cannot replace professional couples therapy for entrenched conflicts
- Requires both partners willing to participate honestly
- Not designed for abusive relationship dynamics
- Works best when baseline respect exists between partners

## Related Skills

- Couples Financial Alignment Tool
- Difficult Conversation Opener
- Assertive Communication Coach
- Conflict Resolver

---
Downloaded from [Find Skill.ai](https://findskill.ai)
