---
name: social-anxiety-party-prep
version: 1.0.0
---

# Social Anxiety Party Prep - Initialization

Pre-party preparation system for social anxiety featuring grounding techniques, 3 reliable talking points, graceful exit strategies, and cognitive reframes to survive any social gathering with minimal distress.

## Structure

```
social-anxiety-party-prep/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This file - setup instructions
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r social-anxiety-party-prep/ ~/.claude/skills/social-anxiety-party-prep/
```

Then reference in your Claude Code prompts:
```
Use skill social-anxiety-party-prep to help me prepare for Saturday's party
```

### For ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation as the system prompt or first message
4. Start by describing your upcoming event

### For Custom GPT / Claude Project

1. Create new Custom GPT or Claude Project
2. Paste `SKILL.md` content into Instructions/System Prompt
3. Save and use for all party prep needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `event_type` | `house_party` | Type of social event (house_party, networking_event, wedding, work_function, family_gathering, casual_hangout) |
| `anxiety_level` | `moderate` | Current anxiety level (mild, moderate, severe) |
| `time_available` | `90_minutes` | How long you plan to stay (30_minutes, 60_minutes, 90_minutes, 2_hours, open_ended) |
| `relationship_to_host` | `acquaintance` | How well you know the host (stranger, acquaintance, friend, close_friend, family) |
| `arrival_strategy` | `slightly_early` | When to arrive (early, slightly_early, on_time, fashionably_late) |

## Quick Start Example

After installing, try this prompt:

```
I'm attending my coworker's birthday party this Saturday evening.
I don't know many people there and I'm already feeling anxious about it.
My social battery is typically low after 90 minutes.

Help me prepare with:
- A grounding routine I can do before going in
- 3 safe conversation starters
- A graceful exit script
- What to tell myself when I start feeling overwhelmed
```

## What This Skill Provides

1. **Pre-Party Grounding Routine** - 5-10 minute box breathing and 5-4-3-2-1 technique
2. **Three Talking Points Framework**:
   - Shared experience observation (low-pressure opener)
   - Light personal question (shifts burden to them)
   - Genuine follow-up (builds connection)
3. **Exit Strategy System**:
   - Irish Goodbye (large parties)
   - Graceful Host Thank-You (smaller gatherings)
   - Casual Time Excuse (universal)
4. **Mid-Party Coping**:
   - Bathroom reset technique
   - Step-outside breaks
   - Physical symptom management
5. **Post-Event Protocol** - Avoiding rumination, scheduling recovery

## Best Paired With

- **Social Battery Preserver** - More exit scripts and energy management
- **Anxiety Spirals Interrupter** - When panic escalates
- **Cognitive Reframing Guide** - For changing thought patterns
- **Conversation Practice Partner** - Practice talking points beforehand

---
Downloaded from [Find Skill.ai](https://findskill.ai)
