---
name: ai-security-policy-writer
version: 1.0.0
---

# AI Security Policy Writer - Initialization

Generate comprehensive AI security policies for organizations covering acceptable AI use, data handling, model governance, prompt injection prevention, ethics guidelines, vendor risk assessment, employee training requirements, and incident response. Aligned with NIST AI RMF, EU AI Act, ISO/IEC 42001, and OWASP Top 10 for LLM Applications.

## Package Contents

```
ai-security-policy-writer/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Quick Start

### Claude Code Installation
```bash
# Copy skill to Claude Code skills directory
cp -r ai-security-policy-writer/ ~/.claude/skills/ai-security-policy-writer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start a new conversation and describe your AI security policy needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_type}}` | `mid-size SaaS company (200-500 employees)` | Organization type and size |
| `{{ai_usage_scope}}` | `customer-facing chatbots, internal code assistants, data analytics pipelines` | How the organization uses AI |
| `{{regulatory_environment}}` | `NIST AI RMF, EU AI Act, SOC 2` | Regulations and standards to comply with |
| `{{data_sensitivity}}` | `customer PII, financial records, proprietary business data` | Types of sensitive data AI systems process |
| `{{risk_tolerance}}` | `moderate` | Organization's risk appetite (conservative, moderate, aggressive) |
| `{{output_format}}` | `markdown with section numbering` | Preferred format for policy documents |

## Example Prompts

### Complete AI Security Policy Suite
```
I'm the CISO of a healthcare SaaS startup with 150 employees. We're deploying
an AI-powered clinical decision support tool that processes patient data (PHI).
We need a complete AI security policy suite before our SOC 2 Type II audit in Q2.
Generate policies covering acceptable AI use for employees, AI data handling
aligned with HIPAA and the EU AI Act, model governance for our ML pipeline,
prompt injection prevention for our patient-facing chatbot, and an AI incident
response plan. Include role assignments, review cadences, and compliance mapping
to NIST AI RMF and ISO 42001.
```

### AI Acceptable Use Policy Only
```
Our 500-person fintech company needs an AI Acceptable Use Policy. Employees
are using ChatGPT, Claude, and GitHub Copilot without formal guidance. We handle
financial data subject to SOC 2 and state privacy laws. Create a policy with
tiered tool classification (approved, restricted, prohibited), data input rules
by sensitivity level, output review requirements, and an exceptions process.
Keep it practical - something engineers will actually read and follow.
```

### Prompt Injection Prevention Policy
```
We're launching a customer-facing AI chatbot built on GPT-4 with RAG access to
our product documentation and customer support knowledge base. Generate a prompt
injection prevention policy covering input validation, system prompt security,
RAG pipeline access controls, output sanitization, and security testing
requirements. Map controls to OWASP Top 10 for LLMs.
```

### AI Vendor Risk Assessment
```
My procurement team needs a framework for evaluating AI vendors. We're considering
three new AI SaaS tools that will process customer PII. Create a vendor risk
assessment policy with classification tiers, pre-procurement security checklists,
required contractual provisions (especially around model training opt-out and
data processing), and ongoing monitoring requirements.
```

### Policy Gap Analysis
```
We have an existing information security policy (ISO 27001 certified) but nothing
specific to AI. We've just deployed three AI systems: an internal code assistant,
a customer support chatbot, and an ML pipeline for fraud detection. Conduct a
gap analysis against NIST AI RMF and the EU AI Act, and recommend which policy
modules to prioritize.
```

## Policy Modules Covered

| Module | Focus | Frameworks |
|--------|-------|------------|
| 1. AI Acceptable Use | Employee AI usage boundaries | NIST GV, EU AI Act Art. 4 |
| 2. AI Data Handling | Data governance for AI | GDPR, NIST MP, ISO 42001 Cl.6 |
| 3. AI Model Governance | Model lifecycle controls | EU AI Act Art. 9-15, NIST MS |
| 4. Prompt Injection Prevention | LLM security controls | OWASP LLM Top 10, NIST MG |
| 5. AI Ethics | Responsible AI principles | EU AI Act Art. 50, ISO 42001 Cl.8 |
| 6. AI Vendor Risk | Third-party AI risk | NIST MP, ISO 42001 Cl.6 |
| 7. AI Training | Employee AI literacy | EU AI Act Art. 4, ISO 42001 Cl.7 |
| 8. AI Incident Response | AI incident procedures | EU AI Act Art. 62, NIST MG |

## Governance Structure

The skill generates documentation for these governance bodies:
- **AI Governance Committee**: Cross-functional oversight body (CISO, CTO, Legal, Privacy, Data)
- **AI Security Officer**: Policy ownership, security assessments, vendor risk
- **AI Ethics Lead**: Bias assessments, ethics complaints, deployment advisory
- **Department AI Champions**: Policy liaisons across business units

## Compliance Framework Coverage

| Framework | Full Name | Key References |
|-----------|-----------|----------------|
| NIST AI RMF | AI Risk Management Framework 1.0 | Govern, Map, Measure, Manage functions |
| EU AI Act | Regulation (EU) 2024/1689 | Articles 4, 5-6, 9-15, 50, 62 |
| ISO 42001 | AI Management Systems | Clauses 4-10 (Plan-Do-Check-Act) |
| OWASP LLM | Top 10 for LLM Applications 2025 | LLM01-LLM10 vulnerabilities |
| NIST AI 600-1 | Generative AI Profile | GAI-specific risk mapping |

## Related Skills

- [AI Security Red Team Prompter](/skills/security-devops/ai-security-red-team-prompter/) - Test AI systems for security vulnerabilities
- [Security Review Checklist Generator](/skills/security-devops/security-review-checklist-generator/) - Generate compliance audit checklists
- [Web App Security Audit](/skills/security-devops/web-app-security-audit/) - Comprehensive web application security audits
- [Incident Postmortem Generator](/skills/security-devops/incident-postmortem-generator/) - Structured incident reports
- [DevOps Expert](/skills/security-devops/devops-expert/) - DevOps practices with security automation

## Troubleshooting

### Policy Suite Too Complex for My Organization
Start with Module 1 (Acceptable Use) and Module 4 (Prompt Injection Prevention) as the highest-impact policies. Add modules as the organization matures.

### Unsure Which Regulations Apply
Provide your operating regions and industry. The skill will map applicable regulations. When in doubt, default to the most stringent standard.

### Engineering Teams Resist Policies
Involve engineering leadership in the review process. The skill generates developer-friendly language with practical examples and automated compliance options.

### Need to Update Existing Policies
Use the Policy Gap Analysis workflow. Provide your current policies and the skill will identify gaps against NIST AI RMF, EU AI Act, and ISO 42001.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
