---
name: aws-iam-policy-writer
version: 1.0.0
---

# Initialization

Generate least-privilege AWS IAM policies from natural language descriptions. Covers all four IAM policy types (identity-based, resource-based, SCPs, permission boundaries), 10+ AWS service patterns (S3, EC2, Lambda, DynamoDB, RDS, SQS, SNS, CloudWatch, Secrets Manager, SSM Parameter Store), condition keys (IP, MFA, encryption, tags, VPC, region, time), cross-account access, policy evaluation logic, wildcard analysis, dangerous permissions, and migration from broad to least-privilege policies.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with IAM policy writing instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Translate natural language to IAM policies** - Convert plain English access descriptions into properly scoped JSON policy documents
2. **Generate all policy types** - Identity-based, resource-based, permission boundaries, SCPs, and session policies
3. **Apply least-privilege methodology** - Start from zero, use specific actions, scope to exact ARNs, add conditions
4. **Write service-specific patterns** - S3 (bucket/object/prefix/cross-account), EC2 (tag-based, region-restricted), Lambda (execution roles, VPC access), DynamoDB (table/item/attribute-level, GSI), RDS (management, IAM auth), SQS/SNS, CloudWatch, Secrets Manager, SSM Parameter Store
5. **Add condition keys** - IP restriction, MFA enforcement, encryption requirements, tag-based access (ABAC), VPC/endpoint restriction, region restriction, time-based access, secure transport
6. **Configure cross-account access** - AssumeRole trust policies with ExternalId, resource-based cross-account policies
7. **Analyze wildcard permissions** - Identify dangerous patterns, suggest restrictions, flag privilege escalation paths
8. **Explain policy evaluation** - Walk through the evaluation chain (explicit deny > SCP > resource policy > permission boundary > session policy > identity policy > implicit deny)
9. **Validate policies** - Provide IAM Policy Simulator commands, Access Analyzer validation, and CloudTrail-based policy generation
10. **Migrate to least-privilege** - Guide migration from broad policies using Access Advisor, Access Analyzer, and CloudTrail activity analysis

## Supported AWS Services

- **S3**: Bucket-level, object-level, prefix-based, cross-account, encryption enforcement
- **EC2**: Instance management, tag-based (ABAC), region-restricted, describe actions
- **Lambda**: Execution roles, invoke permissions, VPC access (ENI), function management
- **DynamoDB**: Table, item (LeadingKeys), attribute-level access, GSI/LSI
- **RDS**: Instance management, IAM database authentication
- **SQS**: Send/receive messages, resource policies (SNS integration)
- **SNS**: Publish to topics, subscription management
- **CloudWatch**: Logs (create/write), metrics (put/get), alarms
- **Secrets Manager**: Read secrets, describe secrets
- **SSM Parameter Store**: Read parameters, path-based access, KMS decrypt
- **KMS**: Encrypt/decrypt, key management, cross-account grants
- **IAM/STS**: AssumeRole, cross-account trust policies, ExternalId

## Policy Types Covered

- Identity-based policies (managed and inline)
- Resource-based policies (S3 bucket policies, SQS queue policies, KMS key policies)
- Permission boundaries
- Service Control Policies (SCPs)
- Session policies

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides AWS CLI commands for policy management (create, attach, simulate, validate) but does not require the AWS CLI to be pre-installed. All policy JSON output is standalone and can be deployed via the AWS Console, CLI, Terraform, or CloudFormation.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r aws-iam-policy-writer/ ~/.claude/skills/aws-iam-policy-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{access_description}}` | `Lambda function that reads from S3 bucket my-data-bucket and writes to DynamoDB table UserSessions` | Plain English description of the access needed |
| `{{aws_services}}` | `S3, DynamoDB, Lambda` | AWS services involved in the policy |
| `{{resource_arns}}` | `arn:aws:s3:::my-data-bucket/*, arn:aws:dynamodb:us-east-1:123456789012:table/UserSessions` | Specific AWS resource ARNs to scope the policy |
| `{{policy_type}}` | `identity` | Type of IAM policy: identity, resource, SCP, or permission_boundary |
| `{{environment}}` | `production` | Target environment for additional scoping |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
