---
name: cloud-security-auditor
version: 1.0.0
---

# Initialization

Audit cloud infrastructure security across AWS, Azure, and GCP. Covers IAM policies, network security groups, encryption at rest and in transit, CIS Benchmarks, common misconfigurations (S3 buckets, open security groups, public endpoints), and step-by-step remediation with CLI commands and IaC templates.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with cloud security audit instructions
- `INIT.md` - This initialization manifest

## Skill Capabilities

This skill enables an AI assistant to:

1. **Gather audit context** - Ask structured questions about cloud providers, workloads, compliance requirements, and organization size
2. **Audit IAM security** - Check root/admin MFA, credential rotation, least-privilege policies, service account hygiene, cross-account trust
3. **Audit network security** - Review security groups, firewall rules, VPC flow logs, public endpoint exposure
4. **Audit encryption** - Verify encryption at rest (S3, EBS, RDS, disks), KMS key rotation, TLS enforcement, database SSL
5. **Audit storage security** - Detect public S3/Blob/GCS buckets, review bucket policies, check versioning and logging
6. **Audit logging and monitoring** - Verify CloudTrail/Activity Log/Audit Logs, check log encryption, review Security Hub/Defender/SCC findings
7. **Run automated scanning** - Guide users through Prowler, ScoutSuite, Checkov, tfsec, and Trivy
8. **Map compliance** - Map findings to SOC 2, ISO 27001, PCI-DSS 4.0, NIST CSF, and HIPAA controls
9. **Generate audit reports** - Produce prioritized reports with executive summary, detailed findings, and remediation matrix
10. **Provide remediation** - Deliver exact CLI commands, Terraform templates, and policy documents for every finding

## Supported Cloud Providers

- **AWS**: IAM, VPC, S3, EC2, RDS, Lambda, EKS, CloudTrail, Security Hub, GuardDuty, KMS, Config, Inspector
- **Azure**: Entra ID, NSGs, Blob Storage, VMs, SQL, Functions, AKS, Activity Log, Defender for Cloud, Key Vault, Policy
- **GCP**: IAM, VPC, Cloud Storage, Compute Engine, Cloud SQL, Cloud Functions, GKE, Audit Logs, Security Command Center, KMS, Organization Policies

## CIS Benchmark Coverage

- CIS AWS Foundations Benchmark v2.0
- CIS Azure Foundations Benchmark v2.0
- CIS Google Cloud Platform Benchmark v2.0

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None. The skill provides CLI commands for cloud provider CLIs (aws, az, gcloud) and open-source tools (Prowler, ScoutSuite, Checkov, tfsec, Trivy) but does not require them to be pre-installed.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r cloud-security-auditor/ ~/.claude/skills/cloud-security-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot, llama, mistral, opensource

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{cloud_provider}}` | `AWS` | My primary cloud provider |
| `{{compliance_frameworks}}` | `CIS Benchmarks` | Compliance standards my organization must meet |
| `{{audit_scope}}` | `comprehensive` | The scope of my cloud security audit |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
